/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.block.ChargedSoilBlock;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DeviceSoilInfuserContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.ThermalTileAugmentable;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DeviceSoilInfuserTile
extends ThermalTileAugmentable
implements ITickableTile.IServerTickable,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "RF", "Area");
    protected static final int BASE_PROCESS_MAX = 4000;
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);
    protected static final int RADIUS = 2;
    protected int radius = 2;
    protected AABB area;
    protected int process;
    protected int processMax = 4000 * this.radius * this.radius;
    protected int processTick = this.getBaseProcessTick() / 4 * this.radius;

    public DeviceSoilInfuserTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_SOIL_INFUSER_TILE.get(), pos, state);
        this.energyStorage = new EnergyStorageCoFH(this.getBaseEnergyStorage(), this.getBaseEnergyXfer());
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    public void tickServer() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.energyStorage.getEnergyStored() >= this.processTick) {
                this.process += this.processTick;
                this.energyStorage.modify(-this.processTick);
                if (this.process >= this.processMax) {
                    this.process -= this.processMax;
                    BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(-this.radius, -1, -this.radius), (BlockPos)this.f_58858_.m_142082_(this.radius, 1, this.radius)).forEach(this::chargeSoil);
                }
            } else {
                this.isActive = false;
            }
        } else if (this.redstoneControl.getState() && this.energyStorage.getEnergyStored() >= this.processTick) {
            this.isActive = true;
        }
        this.updateActiveState(curActive);
        this.chargeEnergy();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceSoilInfuserContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    public int getCurSpeed() {
        return this.isActive ? this.processTick : 0;
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.process <= 0) {
            return 0;
        }
        return scale * Math.min(this.process, this.processMax) / this.processMax;
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        buffer.writeInt(this.processTick);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
        this.processTick = buffer.readInt();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.process = nbt.m_128451_("Proc");
        this.processMax = nbt.m_128451_("ProcMax");
        this.processTick = nbt.m_128451_("ProcTick");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Proc", this.process);
        nbt.m_128405_("ProcMax", this.processMax);
        nbt.m_128405_("ProcTick", this.processTick);
    }

    public int getRadius() {
        return this.radius;
    }

    protected void chargeSoil(BlockPos blockPos) {
        BlockState state = this.f_58857_.m_8055_(blockPos);
        if (state.m_60734_() instanceof ChargedSoilBlock) {
            ChargedSoilBlock.charge(state, this.f_58857_, blockPos);
        }
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            this.chargeSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace()), false), false));
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 2;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"Radius"));
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        this.processMax = 4000 * (1 + this.radius);
        this.processTick = Math.round((float)this.getBaseProcessTick() * baseMod);
        this.area = null;
    }

    public AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.f_58858_.m_142082_(-this.radius, -1, -this.radius), this.f_58858_.m_142082_(1 + this.radius, 1, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? 7923823 : 0x555555;
    }
}

