/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.InsolatorRecipe;
import cofh.thermal.lib.compat.crt.RecipePrintingUtil;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Insolator")
@IRecipeHandler.For(value=InsolatorRecipe.class)
public class CRTInsolatorManager
implements IRecipeManager,
IRecipeHandler<InsolatorRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, Percentaged<IItemStack>[] outputs, IIngredientWithAmount ingredient, int fluidAmount, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(ingredient).input(new CTFluidIngredient[]{new CTFluidIngredient.FluidStackIngredient((IFluidStack)new MCFluidStack(new FluidStack((Fluid)Fluids.f_76193_, fluidAmount)))}).output(outputs);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)crtRecipe.recipe(InsolatorRecipe::new)));
    }

    public RecipeType<InsolatorRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_INSOLATOR;
    }

    public void remove(IIngredient output) {
        this.removeRecipe(output);
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient ... output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput((IRecipeManager)this, output));
    }

    public String dumpToCommandString(IRecipeManager manager, InsolatorRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", [%s], %s, %s, %s);", recipe.m_6671_(), recipe.m_6423_(), RecipePrintingUtil.stringifyWeightedStacks(recipe.getOutputItems(), recipe.getOutputItemChances(), ", "), RecipePrintingUtil.stringifyIngredients(recipe.getInputItems(), " | "), recipe.getInputFluids().get(0).getFluids()[0].getAmount(), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, InsolatorRecipe>> replaceIngredients(IRecipeManager manager, InsolatorRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceIngredientList(recipe.getInputItems(), Ingredient.class, (Recipe)recipe, rules, newIngredients -> id -> new CRTRecipe((ResourceLocation)id).energy(recipe.getEnergy()).setInputItems((List<Ingredient>)newIngredients).setOutputItems(recipe.getOutputItems(), recipe.getOutputItemChances()).setInputFluids(recipe.getInputFluids()).recipe(InsolatorRecipe::new));
    }
}

