/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.event;

import cofh.core.compat.curios.CuriosProxy;
import cofh.lib.util.Utils;
import cofh.thermal.core.inventory.container.storage.SatchelContainer;
import cofh.thermal.core.item.DivingArmorItem;
import cofh.thermal.core.item.SatchelItem;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="thermal")
public class TCoreCommonEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_204029_(FluidTags.f_13131_)) {
            boolean diveChest = player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof DivingArmorItem;
            if (!EnchantmentHelper.m_44934_((LivingEntity)player) && diveChest) {
                event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
            }
            boolean diveLegs = player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof DivingArmorItem;
            if (!player.m_20096_() && diveLegs && Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)Utils.getEnchantment((String)"ensorcellation", (String)"air_affinity")) <= 0) {
                event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
            }
        } else if (player.m_20069_()) {
            boolean diveLegs = player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof DivingArmorItem;
            if (!player.m_20096_() && diveLegs && Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)Utils.getEnchantment((String)"ensorcellation", (String)"air_affinity")) <= 0) {
                event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
            }
        }
    }

    @SubscribeEvent
    public static void handleEntityItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.f_36096_ instanceof SatchelContainer) {
            return;
        }
        Inventory inventory = player.m_150109_();
        boolean[] cancel = new boolean[]{false};
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!(stack.m_41720_() instanceof SatchelItem)) continue;
            cancel[0] = cancel[0] | SatchelItem.onItemPickup(event, stack);
        }
        CuriosProxy.getAllWorn((LivingEntity)player).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack stack = c.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof SatchelItem)) continue;
                ItemStack satchelCopy = stack.m_41777_();
                cancel[0] = cancel[0] | SatchelItem.onItemPickup(event, satchelCopy);
                c.setStackInSlot(i, satchelCopy);
            }
        });
        event.setCanceled(cancel[0]);
    }
}

