/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.init;

import cofh.core.item.EnergyContainerItem;
import cofh.core.item.ItemCoFH;
import cofh.core.item.SpawnEggItemCoFH;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.lib.api.ITNTFactory;
import cofh.lib.block.TntBlockCoFH;
import cofh.lib.item.ArmorMaterialCoFH;
import cofh.lib.util.Constants;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreEntities;
import cofh.thermal.core.item.BeekeeperArmorItem;
import cofh.thermal.core.item.DetonatorItem;
import cofh.thermal.core.item.DivingArmorItem;
import cofh.thermal.core.item.EarthChargeItem;
import cofh.thermal.core.item.FertilizerItem;
import cofh.thermal.core.item.HazmatArmorItem;
import cofh.thermal.core.item.IceChargeItem;
import cofh.thermal.core.item.LightningChargeItem;
import cofh.thermal.core.item.LockItem;
import cofh.thermal.core.item.RedprintItem;
import cofh.thermal.core.item.SatchelItem;
import cofh.thermal.core.item.WrenchItem;
import cofh.thermal.core.item.XpCrystalItem;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import cofh.thermal.lib.item.AugmentItem;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;

public class TCoreItems {
    public static final ArmorMaterialCoFH BEEKEEPER = new ArmorMaterialCoFH("thermal:beekeeper", 4, new int[]{1, 2, 3, 1}, 16, SoundEvents.f_11674_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ThermalCore.ITEMS.get("beekeeper_fabric")}));
    public static final ArmorMaterialCoFH DIVING = new ArmorMaterialCoFH("thermal:diving", 12, new int[]{1, 4, 5, 2}, 20, SoundEvents.f_11672_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ThermalCore.ITEMS.get("diving_fabric")}));
    public static final ArmorMaterialCoFH HAZMAT = new ArmorMaterialCoFH("thermal:hazmat", 6, new int[]{1, 4, 5, 2}, 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ThermalCore.ITEMS.get("hazmat_fabric")}));

    private TCoreItems() {
    }

    public static void register() {
        TCoreItems.registerResources();
        TCoreItems.registerParts();
        TCoreItems.registerAugments();
        TCoreItems.registerMaterials();
        TCoreItems.registerTools();
        TCoreItems.registerArmor();
        TCoreItems.registerSpawnEggs();
    }

    public static void setup() {
        DetonatorItem.registerTNT(Blocks.f_50077_, (ITNTFactory<? extends PrimedTnt>)((ITNTFactory)PrimedTnt::new));
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("slime_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("slime_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("redstone_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("redstone_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("glowstone_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("glowstone_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("ender_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("ender_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("fire_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("fire_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("earth_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("earth_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("ice_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("ice_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("lightning_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("lightning_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("phyto_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("phyto_tnt")).getFactory());
        DetonatorItem.registerTNT((Block)ThermalCore.BLOCKS.get("nuke_tnt"), (ITNTFactory<? extends PrimedTnt>)((TntBlockCoFH)ThermalCore.BLOCKS.get("nuke_tnt")).getFactory());
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_helmet")).setup();
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_chestplate")).setup();
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_leggings")).setup();
        ((DivingArmorItem)ThermalCore.ITEMS.get("diving_boots")).setup();
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rs_control_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("side_config_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("xp_storage_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("upgrade_augment_1"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("upgrade_augment_2"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("upgrade_augment_3"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_storage_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_xfer_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("rf_coil_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("fluid_tank_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("fluid_tank_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("fluid_filter_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("item_filter_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("machine_efficiency_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("machine_catalyst_creative_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("machine_cycle_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("machine_null_augment"));
        ThermalAugmentRules.flagUniqueAugment((Item)ThermalCore.ITEMS.get("dynamo_throttle_augment"));
    }

    private static void registerResources() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("sawdust", group);
        RegistrationHelper.registerItem("coal_coke", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setBurnTime(3200));
        RegistrationHelper.registerItem("bitumen", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setBurnTime(1600));
        RegistrationHelper.registerItem("tar", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setBurnTime(800));
        RegistrationHelper.registerItem("rosin", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setBurnTime(800));
        RegistrationHelper.registerItem("rubber", group);
        RegistrationHelper.registerItem("cured_rubber", group);
        RegistrationHelper.registerItem("slag", group);
        RegistrationHelper.registerItem("rich_slag", group);
        RegistrationHelper.registerItem("syrup_bottle", () -> new HoneyBottleItem(new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_FOODS).m_41495_(Items.f_42590_).m_41489_(Foods.f_38832_).m_41487_(16)));
        RegistrationHelper.registerItem("basalz_rod", group);
        RegistrationHelper.registerItem("basalz_powder", group);
        RegistrationHelper.registerItem("blitz_rod", group);
        RegistrationHelper.registerItem("blitz_powder", group);
        RegistrationHelper.registerItem("blizz_rod", group);
        RegistrationHelper.registerItem("blizz_powder", group);
        RegistrationHelper.registerItem("beekeeper_fabric", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        RegistrationHelper.registerItem("diving_fabric", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        RegistrationHelper.registerItem("hazmat_fabric", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        RegistrationHelper.registerItem("apatite", group);
        RegistrationHelper.registerItem("apatite_dust", group);
        RegistrationHelper.registerItem("cinnabar", group);
        RegistrationHelper.registerItem("cinnabar_dust", group);
        RegistrationHelper.registerItem("niter", group);
        RegistrationHelper.registerItem("niter_dust", group);
        RegistrationHelper.registerItem("sulfur", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setBurnTime(1200));
        RegistrationHelper.registerItem("sulfur_dust", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setBurnTime(1200));
    }

    private static void registerParts() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("redstone_servo", group);
        RegistrationHelper.registerItem("rf_coil", group);
        RegistrationHelper.registerItem("drill_head", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_TOOL_COMPONENTS)));
        RegistrationHelper.registerItem("saw_blade", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_TOOL_COMPONENTS)));
        RegistrationHelper.registerItem("laser_diode", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(Constants.FALSE));
    }

    private static void registerMaterials() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("ender_pearl_dust", group);
        RegistrationHelper.registerVanillaMetalSet("iron", group);
        RegistrationHelper.registerVanillaMetalSet("gold", group);
        RegistrationHelper.registerVanillaMetalSet("copper", group);
        RegistrationHelper.registerVanillaMetalSet("netherite", group);
        RegistrationHelper.registerVanillaGemSet("lapis", group);
        RegistrationHelper.registerVanillaGemSet("diamond", group);
        RegistrationHelper.registerVanillaGemSet("emerald", group);
        RegistrationHelper.registerVanillaGemSet("quartz", group);
        RegistrationHelper.registerMetalSet("tin", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerMetalSet("lead", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerMetalSet("silver", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerMetalSet("nickel", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerAlloySet("bronze", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_BRONZE));
        RegistrationHelper.registerAlloySet("electrum", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_ELECTRUM));
        RegistrationHelper.registerAlloySet("invar", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_INVAR));
        RegistrationHelper.registerAlloySet("constantan", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CONSTANTAN));
        Rarity rarity = Rarity.UNCOMMON;
        RegistrationHelper.registerAlloySet("signalum", group, rarity);
        RegistrationHelper.registerAlloySet("lumium", group, rarity);
        RegistrationHelper.registerAlloySet("enderium", group, rarity);
        RegistrationHelper.registerGemSet("ruby", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerGemSet("sapphire", group, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
    }

    private static void registerTools() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_TOOLS;
        RegistrationHelper.registerItem("wrench", () -> new WrenchItem(new Item.Properties().m_41487_(1).m_41491_(group)));
        RegistrationHelper.registerItem("redprint", () -> new RedprintItem(new Item.Properties().m_41487_(1).m_41491_(group)));
        RegistrationHelper.registerItem("rf_potato", () -> new EnergyContainerItem(new Item.Properties().m_41487_(1).m_41491_(group), 100000, 40){

            public Capability<? extends IEnergyStorage> getEnergyCapability() {
                return ThermalEnergyHelper.getBaseEnergySystem();
            }
        });
        RegistrationHelper.registerItem("xp_crystal", () -> new XpCrystalItem(new Item.Properties().m_41487_(1).m_41491_(group), 10000));
        RegistrationHelper.registerItem("lock", () -> new LockItem(new Item.Properties().m_41491_(group)));
        RegistrationHelper.registerItem("satchel", () -> new SatchelItem(new Item.Properties().m_41487_(1).m_41491_(group), 9));
        RegistrationHelper.registerItem("compost", () -> new FertilizerItem(new Item.Properties().m_41491_(group), 2));
        RegistrationHelper.registerItem("phytogro", () -> new FertilizerItem(new Item.Properties().m_41491_(group)));
        RegistrationHelper.registerItem("junk_net", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag("device_fisher")));
        RegistrationHelper.registerItem("aquachow", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag("device_fisher")));
        RegistrationHelper.registerItem("deep_aquachow", () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag("device_fisher")));
        RegistrationHelper.registerItem("earth_charge", () -> new EarthChargeItem(new Item.Properties().m_41491_(group)));
        RegistrationHelper.registerItem("ice_charge", () -> new IceChargeItem(new Item.Properties().m_41491_(group)));
        RegistrationHelper.registerItem("lightning_charge", () -> new LightningChargeItem(new Item.Properties().m_41491_(group)));
        RegistrationHelper.registerItem("detonator", () -> new DetonatorItem(new Item.Properties().m_41487_(1).m_41491_(group)));
    }

    private static void registerArmor() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_TOOLS;
        ThermalCore.ITEMS.register("beekeeper_helmet", () -> new BeekeeperArmorItem((ArmorMaterial)BEEKEEPER, EquipmentSlot.HEAD, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("beekeeper_chestplate", () -> new BeekeeperArmorItem((ArmorMaterial)BEEKEEPER, EquipmentSlot.CHEST, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("beekeeper_leggings", () -> new BeekeeperArmorItem((ArmorMaterial)BEEKEEPER, EquipmentSlot.LEGS, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("beekeeper_boots", () -> new BeekeeperArmorItem((ArmorMaterial)BEEKEEPER, EquipmentSlot.FEET, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_BEEKEEPER_ARMOR)));
        ThermalCore.ITEMS.register("diving_helmet", () -> new DivingArmorItem((ArmorMaterial)DIVING, EquipmentSlot.HEAD, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("diving_chestplate", () -> new DivingArmorItem((ArmorMaterial)DIVING, EquipmentSlot.CHEST, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("diving_leggings", () -> new DivingArmorItem((ArmorMaterial)DIVING, EquipmentSlot.LEGS, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("diving_boots", () -> new DivingArmorItem((ArmorMaterial)DIVING, EquipmentSlot.FEET, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DIVING_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_helmet", () -> new HazmatArmorItem((ArmorMaterial)HAZMAT, EquipmentSlot.HEAD, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_chestplate", () -> new HazmatArmorItem((ArmorMaterial)HAZMAT, EquipmentSlot.CHEST, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_leggings", () -> new HazmatArmorItem((ArmorMaterial)HAZMAT, EquipmentSlot.LEGS, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
        ThermalCore.ITEMS.register("hazmat_boots", () -> new HazmatArmorItem((ArmorMaterial)HAZMAT, EquipmentSlot.FEET, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_HAZMAT_ARMOR)));
    }

    private static void registerAugments() {
        TCoreItems.registerUpgradeAugments();
        TCoreItems.registerFeatureAugments();
        TCoreItems.registerStorageAugments();
        TCoreItems.registerFilterAugments();
        TCoreItems.registerMachineAugments();
        TCoreItems.registerDynamoAugments();
        TCoreItems.registerAreaAugments();
        TCoreItems.registerPotionAugments();
    }

    private static void registerUpgradeAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        float[] upgradeMods = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 6.0f, 8.5f};
        for (int i = 1; i <= 3; ++i) {
            int tier = i;
            RegistrationHelper.registerItem("upgrade_augment_" + i, () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Upgrade").mod("BaseMod", upgradeMods[tier]).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_UPGRADE_AUGMENTS)));
        }
    }

    private static void registerFeatureAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("rs_control_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().mod("RSCtl", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_RS_CONTROL_AUGMENT)));
        RegistrationHelper.registerItem("side_config_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().mod("SideCfg", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_SIDE_CONFIG_AUGMENT)));
        RegistrationHelper.registerItem("xp_storage_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().mod("XpStr", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_XP_STORAGE_AUGMENT)));
    }

    private static void registerStorageAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("rf_coil_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("RF").mod("RFMax", 4.0f).mod("RFXfer", 4.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("rf_coil_storage_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("RF").mod("RFMax", 6.0f).mod("RFXfer", 2.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("rf_coil_xfer_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("RF").mod("RFMax", 2.0f).mod("RFXfer", 6.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("rf_coil_creative_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group).m_41497_(Rarity.EPIC), AugmentDataHelper.builder().type("RF").mod("RFMax", 16.0f).mod("RFXfer", 16.0f).mod("RFCre", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("fluid_tank_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Fluid").mod("FluidMax", 4.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS)));
        RegistrationHelper.registerItem("fluid_tank_creative_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group).m_41497_(Rarity.EPIC), AugmentDataHelper.builder().type("Fluid").mod("FluidMax", 16.0f).mod("FluidCre", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_STORAGE_AUGMENTS)));
    }

    private static void registerFilterAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("item_filter_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Filter").feature("FilterType", "item").build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_FILTER_AUGMENTS)));
        RegistrationHelper.registerItem("fluid_filter_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Filter").feature("FilterType", "fluid").build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_FILTER_AUGMENTS)));
    }

    private static void registerMachineAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("machine_speed_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Machine").mod("MachinePower", 1.0f).mod("MachineEnergy", 1.1f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_efficiency_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Machine").mod("MachineSpeed", -0.1f).mod("MachineEnergy", 0.9f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_efficiency_creative_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group).m_41497_(Rarity.EPIC), AugmentDataHelper.builder().type("Machine").mod("MachineEnergy", 0.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_output_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Machine").mod("MachineSec", 0.15f).mod("MachineEnergy", 1.25f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_catalyst_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Machine").mod("MachineCat", 0.8f).mod("MachineEnergy", 1.25f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_catalyst_creative_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group).m_41497_(Rarity.EPIC), AugmentDataHelper.builder().type("Machine").mod("MachineCat", 0.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_CREATIVE_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_cycle_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Machine").mod("CycProc", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
        RegistrationHelper.registerItem("machine_null_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Machine").mod("SecNull", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MACHINE_AUGMENTS)));
    }

    private static void registerDynamoAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("dynamo_output_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Dynamo").mod("DynamoPower", 1.0f).mod("DynamoEnergy", 0.9f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DYNAMO_AUGMENTS)));
        RegistrationHelper.registerItem("dynamo_fuel_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Dynamo").mod("DynamoEnergy", 1.1f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DYNAMO_AUGMENTS)));
        RegistrationHelper.registerItem("dynamo_throttle_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Dynamo").mod("DynamoThrottle", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_DYNAMO_AUGMENTS)));
    }

    private static void registerAreaAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("area_radius_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Area").mod("Radius", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_AREA_AUGMENTS)));
    }

    private static void registerPotionAugments() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("potion_amplifier_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Potion").mod("PotionAmp", 1.0f).mod("PotionDur", -0.25f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_POTION_AUGMENTS)));
        RegistrationHelper.registerItem("potion_duration_augment", () -> new AugmentItem(new Item.Properties().m_41491_(group), AugmentDataHelper.builder().type("Potion").mod("PotionDur", 1.0f).build()).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_POTION_AUGMENTS)));
    }

    private static void registerSpawnEggs() {
        CreativeModeTab group = ThermalItemGroups.THERMAL_ITEMS;
        RegistrationHelper.registerItem("basalz_spawn_egg", () -> new SpawnEggItemCoFH(() -> TCoreEntities.BASALZ.get(), 3553344, 525319, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BASALZ)));
        RegistrationHelper.registerItem("blizz_spawn_egg", () -> new SpawnEggItemCoFH(() -> TCoreEntities.BLIZZ.get(), 14212069, 9558524, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLIZZ)));
        RegistrationHelper.registerItem("blitz_spawn_egg", () -> new SpawnEggItemCoFH(() -> TCoreEntities.BLITZ.get(), 13233919, 16767358, new Item.Properties().m_41491_(group)).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLITZ)));
    }
}

