/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util;

import cofh.core.entity.AbstractGrenade;
import cofh.core.entity.AbstractTNTMinecart;
import cofh.core.item.BlockItemCoFH;
import cofh.core.item.BlockNamedItemCoFH;
import cofh.core.item.CoinItem;
import cofh.core.item.CountedItem;
import cofh.core.item.GrenadeItem;
import cofh.core.item.ItemCoFH;
import cofh.core.item.MinecartItemCoFH;
import cofh.lib.api.IDetonatable;
import cofh.lib.block.CropBlockCoFH;
import cofh.lib.block.CropBlockPerennial;
import cofh.lib.block.CropBlockTall;
import cofh.lib.block.TntBlockCoFH;
import cofh.lib.entity.PrimedTntCoFH;
import cofh.lib.util.Constants;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.entity.explosive.DetonateUtils;
import cofh.thermal.core.entity.explosive.Grenade;
import cofh.thermal.core.entity.explosive.ThermalTNTEntity;
import cofh.thermal.core.entity.explosive.ThermalTNTMinecart;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import cofh.thermal.lib.item.BlockItemAugmentable;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;

public class RegistrationHelper {
    public static void registerBlock(String name, Supplier<Block> sup) {
        RegistrationHelper.registerBlock(name, sup, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerBlock(name, sup, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, CreativeModeTab group) {
        RegistrationHelper.registerBlock(name, sup, group, (Supplier<Boolean>)Constants.TRUE, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, CreativeModeTab group, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerBlock(name, sup, group, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity) {
        RegistrationHelper.registerBlock(name, sup, rarity, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerBlock(name, sup, rarity, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, CreativeModeTab group, Rarity rarity, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerBlock(name, sup, group, rarity, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, CreativeModeTab group, String modId) {
        RegistrationHelper.registerBlock(name, sup, group, Rarity.COMMON, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, Supplier<Boolean> showInGroups, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, showInGroups, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, CreativeModeTab group, Supplier<Boolean> showInGroups, String modId) {
        RegistrationHelper.registerBlock(name, sup, group, Rarity.COMMON, showInGroups, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, rarity, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, CreativeModeTab group, Rarity rarity, String modId) {
        RegistrationHelper.registerBlock(name, sup, group, rarity, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity, Supplier<Boolean> showInGroups, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, rarity, showInGroups, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, CreativeModeTab group, Rarity rarity, Supplier<Boolean> showInGroups, String modId) {
        RegistrationHelper.registerBlockAndItem(name, sup, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get(name), new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups).setModId(modId));
    }

    public static void registerBlockOnly(String name, Supplier<Block> sup) {
        ThermalCore.BLOCKS.register(name, sup);
    }

    public static void registerBlockAndItem(String name, Supplier<Block> blockSup, Supplier<Item> itemSup) {
        ThermalCore.BLOCKS.register(name, blockSup);
        ThermalCore.ITEMS.register(name, itemSup);
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerAugmentableBlock(name, sup, numSlots, validAugment, showInGroups, "thermal");
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, String modId) {
        RegistrationHelper.registerAugmentableBlock(name, sup, numSlots, validAugment, ThermalItemGroups.THERMAL_DEVICES, Rarity.COMMON, Constants.TRUE, modId);
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, Supplier<Boolean> showInGroups, String modId) {
        RegistrationHelper.registerAugmentableBlock(name, sup, numSlots, validAugment, ThermalItemGroups.THERMAL_DEVICES, Rarity.COMMON, showInGroups, modId);
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, CreativeModeTab group, Rarity rarity, Supplier<Boolean> showInGroups, String modId) {
        ThermalCore.BLOCKS.register(name, sup);
        ThermalCore.ITEMS.register(name, () -> new BlockItemAugmentable((Block)ThermalCore.BLOCKS.get(name), new Item.Properties().m_41491_(group).m_41497_(rarity)).setNumSlots(numSlots).setAugValidator(validAugment).setShowInGroups(showInGroups).setModId(modId));
    }

    public static void registerWoodBlockSet(String woodName, Material material, MaterialColor color, float hardness, float resistance, SoundType soundType, String modId) {
        RegistrationHelper.registerBlock(woodName + "_planks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60913_(hardness, resistance).m_60918_(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60913_(hardness, resistance).m_60918_(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_stairs", () -> new StairBlock(() -> ((Block)ThermalCore.BLOCKS.get(woodName + "_planks")).m_49966_(), BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60913_(hardness, resistance).m_60918_(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60978_(resistance).m_60918_(soundType).m_60955_()), modId);
        RegistrationHelper.registerBlock(woodName + "_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60978_(resistance).m_60918_(soundType).m_60955_().m_60922_((state, reader, pos, entityType) -> false)), modId);
        RegistrationHelper.registerBlock(woodName + "_button", () -> new WoodButtonBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.5f).m_60918_(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60910_().m_60978_(0.5f).m_60918_(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60913_(hardness, resistance).m_60918_(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60913_(hardness, resistance).m_60918_(soundType)), modId);
    }

    public static RegistryObject<Item> registerItem(String name, Supplier<Item> sup) {
        return ThermalCore.ITEMS.register(name, sup);
    }

    public static RegistryObject<Item> registerItem(String name, CreativeModeTab group) {
        return RegistrationHelper.registerItem(name, group, Rarity.COMMON);
    }

    public static RegistryObject<Item> registerItem(String name, CreativeModeTab group, Rarity rarity) {
        return RegistrationHelper.registerItem(name, () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)));
    }

    public static void registerMetalSet(String prefix, CreativeModeTab group, Rarity rarity) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, Constants.TRUE, false, false, "thermal");
    }

    public static void registerMetalSet(String prefix, CreativeModeTab group, Rarity rarity, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, showInGroups, false, false, "thermal");
    }

    public static void registerMetalSet(String prefix, CreativeModeTab group, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, showInGroups, false, false, "thermal");
    }

    public static void registerAlloySet(String prefix, CreativeModeTab group, Rarity rarity) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, Constants.TRUE, false, true, "thermal");
    }

    public static void registerAlloySet(String prefix, CreativeModeTab group, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, showInGroups, false, true, "thermal");
    }

    public static void registerVanillaMetalSet(String prefix, CreativeModeTab group) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, Constants.TRUE, true, false, "thermal");
    }

    public static void registerMetalSet(String prefix, CreativeModeTab group, Rarity rarity, Supplier<Boolean> showInGroups, boolean vanilla, boolean alloy, String modId) {
        if (prefix.equals("copper") || prefix.equals("netherite")) {
            ThermalCore.ITEMS.register(prefix + "_nugget", () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups).setModId(modId));
        }
        if (!vanilla) {
            if (!alloy) {
                ThermalCore.ITEMS.register("raw_" + prefix, () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups).setModId(modId));
            }
            ThermalCore.ITEMS.register(prefix + "_ingot", () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups).setModId(modId));
            ThermalCore.ITEMS.register(prefix + "_nugget", () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups).setModId(modId));
        }
        ThermalCore.ITEMS.register(prefix + "_dust", () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups).setModId(modId));
        ThermalCore.ITEMS.register(prefix + "_gear", () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups).setModId(modId));
        ThermalCore.ITEMS.register(prefix + "_plate", () -> new CountedItem(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(() -> RegistrationHelper.lambda$registerMetalSet$20((Supplier)showInGroups)).setModId(modId));
        ThermalCore.ITEMS.register(prefix + "_coin", () -> new CoinItem(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(() -> RegistrationHelper.lambda$registerMetalSet$22((Supplier)showInGroups)).setModId(modId));
    }

    public static void registerGemSet(String prefix, CreativeModeTab group, Rarity rarity, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerGemSet(prefix, group, rarity, showInGroups, false);
    }

    public static void registerGemSet(String prefix, CreativeModeTab group, Supplier<Boolean> showInGroups) {
        RegistrationHelper.registerGemSet(prefix, group, Rarity.COMMON, showInGroups, false);
    }

    public static void registerVanillaGemSet(String prefix, CreativeModeTab group) {
        RegistrationHelper.registerGemSet(prefix, group, Rarity.COMMON, Constants.TRUE, true);
    }

    public static void registerGemSet(String prefix, CreativeModeTab group, Rarity rarity, Supplier<Boolean> showInGroups, boolean vanilla) {
        if (!vanilla) {
            ThermalCore.ITEMS.register(prefix, () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups));
        }
        ThermalCore.ITEMS.register(prefix + "_dust", () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups));
        ThermalCore.ITEMS.register(prefix + "_gear", () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41497_(rarity)).setShowInGroups(showInGroups));
    }

    public static void registerAnnual(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropBlockCoFH(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56758_)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerTallAnnual(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropBlockTall(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56758_)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerPerennial(String id) {
        RegistrationHelper.registerPerennial(id, 7);
    }

    public static void registerPerennial(String id, int postHarvestAge) {
        ThermalCore.BLOCKS.register(id, () -> new CropBlockPerennial(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56758_)).postHarvestAge(postHarvestAge).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerCropAndSeed(String id) {
        RegistrationHelper.registerCropAndSeed(id, ThermalItemGroups.THERMAL_FOODS);
    }

    public static void registerCropAndSeed(String id, FoodProperties food) {
        RegistrationHelper.registerCropAndSeed(id, ThermalItemGroups.THERMAL_FOODS, food);
    }

    public static void registerCropAndSeed(String id, CreativeModeTab group) {
        RegistrationHelper.registerCropAndSeed(id, group, null);
    }

    public static void registerCropAndSeed(String id, CreativeModeTab group, FoodProperties food) {
        if (food != null) {
            ThermalCore.ITEMS.register(id, () -> new ItemCoFH(new Item.Properties().m_41491_(group).m_41489_(food)).setModId("thermal_cultivation"));
        } else {
            ThermalCore.ITEMS.register(id, () -> new ItemCoFH(new Item.Properties().m_41491_(group)).setModId("thermal_cultivation"));
        }
        ThermalCore.ITEMS.register(RegistrationHelper.seeds(id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), new Item.Properties().m_41491_(group)).setModId("thermal_cultivation"));
    }

    public static void registerSpores(String id) {
        RegistrationHelper.registerSpores(id, ThermalItemGroups.THERMAL_FOODS);
    }

    public static void registerSpores(String id, CreativeModeTab group) {
        ThermalCore.ITEMS.register(RegistrationHelper.spores(id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), new Item.Properties().m_41491_(group)).setModId("thermal_cultivation"));
    }

    public static String deepslate(String id) {
        return "deepslate_" + id;
    }

    public static String netherrack(String id) {
        return "netherrack_" + id;
    }

    public static String raw(String id) {
        return "raw_" + id;
    }

    public static String block(String id) {
        return id + "_block";
    }

    public static String seeds(String id) {
        return id + "_seeds";
    }

    public static String spores(String id) {
        return id + "_spores";
    }

    public static void registerGrenade(String id, final IDetonatable.IDetonateAction action, Supplier<Boolean> flag) {
        final RegistryObject entity = ThermalCore.ENTITIES.register(id, () -> EntityType.Builder.m_20704_((type, world) -> new Grenade((EntityType<? extends AbstractGrenade>)type, world, action), (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(id));
        RegistrationHelper.registerItem(id, () -> new GrenadeItem((GrenadeItem.IGrenadeFactory)new GrenadeItem.IGrenadeFactory<AbstractGrenade>(){

            public AbstractGrenade createGrenade(Level level, LivingEntity living) {
                return new Grenade((EntityType<? extends AbstractGrenade>)((EntityType)entity.get()), level, action, living);
            }

            public AbstractGrenade createGrenade(Level level, double posX, double posY, double posZ) {
                return new Grenade((EntityType<? extends AbstractGrenade>)((EntityType)entity.get()), level, action, posX, posY, posZ);
            }
        }, new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_TOOLS).m_41487_(16)).setShowInGroups(flag));
        DetonateUtils.GRENADES.add((RegistryObject<EntityType<? extends AbstractGrenade>>)entity);
    }

    public static void registerTNT(String id, IDetonatable.IDetonateAction action, Supplier<Boolean> flag) {
        RegistryObject tntEntity = ThermalCore.ENTITIES.register(id, () -> EntityType.Builder.m_20704_((type, world) -> new ThermalTNTEntity((EntityType<? extends PrimedTntCoFH>)type, world, action), (MobCategory)MobCategory.MISC).m_20719_().m_20699_(0.98f, 0.98f).m_20712_(id));
        RegistrationHelper.registerBlock(id, () -> new TntBlockCoFH((world, x, y, z, igniter) -> new ThermalTNTEntity((EntityType<? extends PrimedTntCoFH>)((EntityType)tntEntity.get()), world, action, x, y, z, igniter), BlockBehaviour.Properties.m_60944_((Material)Material.f_76273_, (MaterialColor)MaterialColor.f_76416_).m_60978_(0.0f).m_60918_(SoundType.f_56740_)), ThermalItemGroups.THERMAL_TOOLS, flag);
        DetonateUtils.TNT.add((RegistryObject<EntityType<? extends PrimedTntCoFH>>)tntEntity);
    }

    public static void registerTNTMinecart(String id, String tntId, IDetonatable.IDetonateAction action, Supplier<Boolean> flag) {
        RegistryObject entity = ThermalCore.ENTITIES.register(id, () -> EntityType.Builder.m_20704_((type, world) -> new ThermalTNTMinecart(type, world, action, (Block)ThermalCore.BLOCKS.get(tntId)), (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.7f).m_20712_(id));
        ThermalCore.ITEMS.register(id, () -> new MinecartItemCoFH((world, x, y, z) -> new ThermalTNTMinecart((EntityType)entity.get(), world, action, (Block)ThermalCore.BLOCKS.get(tntId), x, y, z), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_TOOLS)).setShowInGroups(flag).setModId("thermal_locomotion"));
        DetonateUtils.CARTS.add((RegistryObject<EntityType<? extends AbstractTNTMinecart>>)entity);
    }

    private static /* synthetic */ Boolean lambda$registerMetalSet$22(Supplier showInGroups) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_COINS).get() != false && (Boolean)showInGroups.get() != false;
    }

    private static /* synthetic */ Boolean lambda$registerMetalSet$20(Supplier showInGroups) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_PLATES).get() != false && (Boolean)showInGroups.get() != false;
    }
}

