/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.FurnaceRecipe;
import cofh.thermal.lib.util.managers.SingleItemRecipeManager;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class FurnaceRecipeManager
extends SingleItemRecipeManager {
    private static final FurnaceRecipeManager INSTANCE = new FurnaceRecipeManager();
    protected static final int DEFAULT_ENERGY = 2000;
    protected static boolean defaultFurnaceRecipes = true;
    protected static boolean defaultFoodRecipes = true;
    protected List<FurnaceRecipe> convertedRecipes = new ArrayList<FurnaceRecipe>();

    public static FurnaceRecipeManager instance() {
        return INSTANCE;
    }

    private FurnaceRecipeManager() {
        super(2000, 1, 0);
    }

    @Override
    protected void clear() {
        this.recipeMap.clear();
        this.convertedRecipes.clear();
    }

    @Override
    public void config() {
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        if (defaultFurnaceRecipes) {
            ThermalCore.LOG.debug("Adding default Furnace recipes to the Redstone Furnace...");
            this.createConvertedRecipes(recipeManager);
            for (ThermalRecipe thermalRecipe : this.getConvertedRecipes()) {
                this.addRecipe(thermalRecipe);
            }
        }
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_FURNACE);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }

    public List<FurnaceRecipe> getConvertedRecipes() {
        return this.convertedRecipes;
    }

    protected void createConvertedRecipes(RecipeManager recipeManager) {
        for (Recipe recipe : recipeManager.m_44054_(RecipeType.f_44108_).values()) {
            this.createConvertedRecipe((AbstractCookingRecipe)recipe);
        }
    }

    protected boolean createConvertedRecipe(AbstractCookingRecipe recipe) {
        if (recipe.m_5598_() || recipe.m_8043_().m_41619_()) {
            return false;
        }
        this.convertedRecipes.add(this.convert(recipe));
        return true;
    }

    protected FurnaceRecipe convert(AbstractCookingRecipe recipe) {
        ItemStack recipeOutput = recipe.m_8043_();
        float experience = recipe.m_43750_();
        int energy = defaultFoodRecipes && recipeOutput.m_41720_().m_41472_() ? this.defaultEnergy / 2 : this.defaultEnergy;
        return new FurnaceRecipe(new ResourceLocation("thermal", "furnace_" + ((Ingredient)recipe.m_7527_().get(0)).hashCode()), energy, experience, recipe);
    }
}

