/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.InsolatorRecipe;
import cofh.thermal.lib.util.managers.SingleItemRecipeManager;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.CatalyzedMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.DisenchantMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeManager
extends SingleItemRecipeManager.Catalyzed {
    private static final InsolatorRecipeManager INSTANCE = new InsolatorRecipeManager();
    protected static final int DEFAULT_ENERGY = 20000;
    protected int defaultWater = 500;

    public static InsolatorRecipeManager instance() {
        return INSTANCE;
    }

    private InsolatorRecipeManager() {
        super(20000, 4, 0);
    }

    public int getDefaultWater() {
        return this.defaultWater;
    }

    @Override
    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids, BaseMachineRecipe.RecipeType type) {
        BaseMachineRecipe recipe;
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack input = inputItems.get(0);
        if (input.m_41619_()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        if (type == BaseMachineRecipe.RecipeType.DISENCHANT) {
            recipe = new DisenchantMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
            this.recipeMap.put(InsolatorRecipeManager.makeComparable(input), recipe);
        } else {
            recipe = new InternalInsolatorRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
            this.recipeMap.put(InsolatorRecipeManager.makeNBTComparable(input), recipe);
        }
        return recipe;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_INSOLATOR);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((InsolatorRecipe)((Object)entry.getValue()));
        }
        Map catalysts = recipeManager.m_44054_(TCoreRecipeTypes.CATALYST_INSOLATOR);
        for (Map.Entry entry : catalysts.entrySet()) {
            this.addCatalyst((ThermalCatalyst)((Object)entry.getValue()));
        }
    }

    protected static class InternalInsolatorRecipe
    extends CatalyzedMachineRecipe {
        public InternalInsolatorRecipe(int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
            super(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        }

        @Override
        public List<Integer> getInputFluidCounts(IMachineInventory inventory) {
            if (this.inputFluids.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> ret = new ArrayList<Integer>(this.inputFluids.size());
            for (FluidStack input : this.inputFluids) {
                ret.add(input.getAmount());
            }
            return ret;
        }

        @Override
        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return InsolatorRecipeManager.instance().getCatalyst(input);
        }
    }
}

