/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.crt.actions;

import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.Registry;

public class ActionRemoveThermalRecipeByOutput
extends ActionRecipeBase {
    private final IIngredient[] outputs;
    private final IFluidStack[] fluids;

    public ActionRemoveThermalRecipeByOutput(IRecipeManager manager, IIngredient[] outputs) {
        super(manager);
        this.outputs = outputs;
        this.fluids = new IFluidStack[0];
    }

    public ActionRemoveThermalRecipeByOutput(IRecipeManager manager, IFluidStack[] fluids) {
        super(manager);
        this.outputs = new IIngredient[0];
        this.fluids = fluids;
    }

    public ActionRemoveThermalRecipeByOutput(IRecipeManager manager, IIngredient[] outputs, IFluidStack[] fluids) {
        super(manager);
        this.outputs = outputs;
        this.fluids = fluids;
    }

    public void apply() {
        Iterator iter = this.getManager().getRecipes().entrySet().iterator();
        while (iter.hasNext()) {
            int i;
            ThermalRecipe recipe = (ThermalRecipe)((Object)iter.next().getValue());
            if (recipe.getOutputItems().size() != this.outputs.length || recipe.getOutputFluids().size() != this.fluids.length) continue;
            boolean valid = true;
            for (i = 0; i < recipe.getOutputItems().size(); ++i) {
                if (this.outputs[i].matches((IItemStack)new MCItemStack(recipe.getOutputItems().get(i)))) continue;
                valid = false;
                break;
            }
            for (i = 0; i < recipe.getOutputFluids().size(); ++i) {
                if (this.fluids[i].containsOther((IFluidStack)new MCFluidStackMutable(recipe.getOutputFluids().get(i))) || new MCFluidStackMutable(recipe.getOutputFluids().get(i)).containsOther(this.fluids[i])) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            iter.remove();
        }
    }

    public String describe() {
        return "Removing \"" + Registry.f_122864_.m_7981_((Object)this.getManager().getRecipeType()) + "\" recipes with outputs: " + Arrays.toString(this.outputs) + "\" and fluid outputs: \"" + Arrays.toString(this.fluids) + "\"";
    }
}

