/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.jei;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class ThermalCatalystCategory<T extends ThermalCatalyst>
implements IRecipeCategory<T> {
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected Component name;
    protected IDrawableStatic slot;

    public ThermalCatalystCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)icon);
        this.background = guiHelper.drawableBuilder(Drawables.JEI_TEXTURE, 26, 11, 140, 62).addPadding(0, 0, 16, 8).build();
        this.slot = Drawables.getDrawables(guiHelper).getSlot(0);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Component getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 17, 23).addIngredients(((ThermalCatalyst)((Object)recipe)).getIngredient());
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.slot.draw(matrixStack, 16, 22);
        Minecraft minecraft = Minecraft.m_91087_();
        String primaryMod = StringHelper.localize((String)"info.thermal.primary_mod") + ": " + ((ThermalCatalyst)((Object)recipe)).getPrimaryMod() + "x";
        minecraft.f_91062_.m_92883_(matrixStack, primaryMod, 44.0f, 8.0f, -10461088);
        String secondaryMod = StringHelper.localize((String)"info.thermal.secondary_mod") + ": " + ((ThermalCatalyst)((Object)recipe)).getSecondaryMod() + "x";
        minecraft.f_91062_.m_92883_(matrixStack, secondaryMod, 44.0f, 20.0f, -10461088);
        String energyMod = StringHelper.localize((String)"info.thermal.energy_mod") + ": " + ((ThermalCatalyst)((Object)recipe)).getEnergyMod() + "x";
        minecraft.f_91062_.m_92883_(matrixStack, energyMod, 44.0f, 32.0f, -10461088);
        String useChance = StringHelper.localize((String)"info.thermal.use_chance") + ": " + StringHelper.DF0.format(((ThermalCatalyst)((Object)recipe)).getUseChance() * 100.0f) + "%";
        minecraft.f_91062_.m_92883_(matrixStack, useChance, 44.0f, 44.0f, -10461088);
    }
}

