/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.recipes.SerializableRecipe;
import cofh.thermal.core.ThermalCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public abstract class ThermalFuel
extends SerializableRecipe {
    protected final List<Ingredient> inputItems = new ArrayList<Ingredient>();
    protected final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
    protected int energy;

    protected ThermalFuel(ResourceLocation recipeId, int energy, List<Ingredient> inputItems, List<FluidIngredient> inputFluids) {
        super(recipeId);
        if ((inputItems == null || inputItems.isEmpty()) && (inputFluids == null || inputFluids.isEmpty())) {
            ThermalCore.LOG.warn("Invalid Thermal Series fuel: " + recipeId + "\nRefer to the fuel's ResourceLocation to find the mod responsible and let them know!");
        }
        this.energy = energy;
        if (inputItems != null) {
            this.inputItems.addAll(inputItems);
        }
        if (inputFluids != null) {
            this.inputFluids.addAll(inputFluids);
        }
        this.trim();
    }

    private void trim() {
        ((ArrayList)this.inputItems).trimToSize();
        ((ArrayList)this.inputFluids).trimToSize();
    }

    public List<Ingredient> getInputItems() {
        return this.inputItems;
    }

    public List<FluidIngredient> getInputFluids() {
        return this.inputFluids;
    }

    public int getEnergy() {
        return this.energy;
    }
}

