/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.renderer.entity;

import com.github.teamfusion.rottencreatures.client.model.BurnedModel;
import com.github.teamfusion.rottencreatures.client.model.LayerBuilder;
import com.github.teamfusion.rottencreatures.client.renderer.entity.layers.BurnedLavaLayer;
import com.github.teamfusion.rottencreatures.common.entities.Burned;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BurnedRenderer
extends AbstractZombieRenderer<Burned, BurnedModel> {
    public static final LayerBuilder LAYER = LayerBuilder.of("burned");
    public static final ResourceLocation BURNED_LOCATION = new ResourceLocation("rottencreatures", "textures/entity/burned/burned.png");
    public static final ResourceLocation OBSIDIAN_LOCATION = new ResourceLocation("rottencreatures", "textures/entity/burned/burned_obsidian.png");
    public static final ResourceLocation CRAZY_LOCATION = new ResourceLocation("rottencreatures", "textures/entity/burned/burned_crazy.png");

    public BurnedRenderer(EntityRendererProvider.Context context) {
        super(context, (ZombieModel)new BurnedModel(context.m_174023_(LAYER.getMain())), (ZombieModel)new BurnedModel(context.m_174023_(LAYER.getInner())), (ZombieModel)new BurnedModel(context.m_174023_(LAYER.getOuter())));
        this.m_115326_(new BurnedLavaLayer((RenderLayerParent<Burned, BurnedModel>)this));
    }

    public ResourceLocation getTextureLocation(Burned burned) {
        return burned.isObsidian() ? OBSIDIAN_LOCATION : (burned.isCrazy() ? CRAZY_LOCATION : BURNED_LOCATION);
    }

    protected void setupRotations(Burned burned, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta) {
        super.m_7523_((LivingEntity)burned, matrices, animationProgress, bodyYaw, tickDelta);
        if (!((double)burned.f_20924_ < 0.01)) {
            float timestamp = burned.f_20925_ - burned.f_20924_ * (1.0f - tickDelta) + 6.0f;
            float degreeModifier = (Math.abs(timestamp % 13.0f - 6.5f) - 3.25f) / 3.25f;
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(6.5f * degreeModifier));
        }
    }
}

