/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.renderer.entity.layers;

import com.github.teamfusion.rottencreatures.client.model.ImmortalModel;
import com.github.teamfusion.rottencreatures.client.model.LayerBuilder;
import com.github.teamfusion.rottencreatures.common.entities.Immortal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class DashAttackLayer<T extends Immortal>
extends RenderLayer<T, ImmortalModel<T>> {
    public static final LayerBuilder LAYER = LayerBuilder.of("dash_attack");
    private final ModelPart box;

    public DashAttackLayer(RenderLayerParent<T, ImmortalModel<T>> renderLayerParent, EntityModelSet modelSet) {
        super(renderLayerParent);
        this.box = modelSet.m_171103_(LAYER.getMain()).m_171324_("box");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("box", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -16.0f, -8.0f, 16.0f, 32.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void render(PoseStack matrices, MultiBufferSource source, int light, T entity, float angle, float distance, float tickDelta, float animationProgress, float yaw, float pitch) {
        if (entity.m_21209_()) {
            VertexConsumer vertices = source.m_6299_(RenderType.m_110458_((ResourceLocation)new ResourceLocation("textures/entity/trident_riptide.png")));
            for (int i = 0; i < 3; ++i) {
                matrices.m_85836_();
                float degrees = animationProgress * (float)(-(45 + i * 5));
                matrices.m_85845_(Vector3f.f_122225_.m_122240_(degrees));
                float scale = 0.75f * (float)i;
                matrices.m_85841_(scale, scale, scale);
                matrices.m_85837_(0.0, (double)(-0.2f + 0.6f * (float)i), 0.0);
                this.box.m_104301_(matrices, vertices, light, OverlayTexture.f_118083_);
                matrices.m_85849_();
            }
        }
    }
}

