/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.entities;

import com.github.teamfusion.rottencreatures.common.entities.Scarab;
import com.github.teamfusion.rottencreatures.common.entities.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Mummy
extends SpellcasterZombie {
    private static final EntityDataAccessor<Boolean> DATA_IS_ANCIENT = SynchedEntityData.m_135353_(Mummy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Mummy(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 10;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_IS_ANCIENT, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, 0.18).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SpellcasterZombie.CastingSpellGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonScarabsGoal());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19853_.m_46791_() == Difficulty.NORMAL || this.f_19853_.m_46791_() == Difficulty.HARD) {
            if ((double)this.m_21223_() <= 18.0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200));
            } else if ((double)this.m_21223_() <= 10.0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200, 1));
            } else if ((double)this.m_21223_() <= 6.0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200));
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean hurtTarget = super.m_7327_(entity);
        if (hurtTarget && this.m_21205_().m_41619_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            living.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 140 * (int)modifier, 2), (Entity)this);
            if (this.f_19796_.nextBoolean()) {
                this.summonScarabs(2);
            }
        }
        return hurtTarget;
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.summonScarabs(3);
    }

    private void summonScarabs(int max) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (int i = 0; i <= this.f_19796_.nextInt(max); ++i) {
                BlockPos pos = this.m_142538_().m_142082_(0, 1, 0);
                Scarab scarab = this.isAncient() ? (Scarab)RCEntityTypes.FLYING_SCARAB.get().m_20615_(this.f_19853_) : (Scarab)RCEntityTypes.SCARAB.get().m_20615_(this.f_19853_);
                scarab.m_20035_(pos, 0.0f, 0.0f);
                scarab.m_6518_((ServerLevelAccessor)level2, this.f_19853_.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
                level2.m_7967_((Entity)scarab);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsAncient", this.isAncient());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAncient(tag.m_128471_("IsAncient"));
    }

    public boolean m_6162_() {
        return false;
    }

    protected boolean m_5884_() {
        return false;
    }

    public boolean isAncient() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IS_ANCIENT);
    }

    private void setAncient(boolean ancient) {
        this.m_20088_().m_135381_(DATA_IS_ANCIENT, (Object)ancient);
    }

    public static boolean checkMummySpawnRules(EntityType<Mummy> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Mummy.m_33017_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        if (this.f_19796_.nextFloat() <= 0.3f) {
            this.setAncient(true);
        }
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    class SummonScarabsGoal
    extends SpellcasterZombie.UseSpellGoal {
        SummonScarabsGoal() {
            super(Mummy.this);
        }

        @Override
        protected void performSpellCasting() {
            Mummy.this.summonScarabs(5);
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }
    }
}

