/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.entities;

import java.util.Collection;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Swampy
extends Zombie {
    public Swampy(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 4;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_6878_() {
        super.m_6878_();
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 3.0);
    }

    public boolean m_7327_(Entity entity) {
        boolean hurt = super.m_7327_(entity);
        if (hurt && this.m_21205_().m_41619_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            living.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 140 * (int)modifier), (Entity)this);
            living.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 140 * (int)modifier), (Entity)this);
        }
        if (this.m_6162_()) {
            this.m_6074_();
        }
        return hurt;
    }

    public void m_7023_(Vec3 vec3) {
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.m_20069_() ? 1.5f : 1.0f));
        super.m_7023_(vec3);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.f_19853_.f_46443_ && (this.f_19796_.nextFloat() <= 0.8f || this.m_6162_())) {
            this.spawnLingeringCloud();
            if (this.m_6162_()) {
                Vec3 pos = this.m_142469_().m_82399_();
                for (int i = 0; i < 40; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.f_19796_.nextGaussian() * 0.2, this.f_19796_.nextGaussian() * 0.2, this.f_19796_.nextGaussian() * 0.2);
                }
            }
        }
    }

    public static boolean checkSwampySpawnRules(EntityType<Swampy> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Swampy.m_33017_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }

    private void spawnLingeringCloud() {
        Collection effects = this.m_21220_();
        AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(2.5f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(10);
        cloud.m_19734_(cloud.m_19748_() / 2);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 200));
        if (!effects.isEmpty()) {
            for (MobEffectInstance effect : effects) {
                cloud.m_19716_(new MobEffectInstance(effect));
            }
        }
        this.f_19853_.m_7967_((Entity)cloud);
    }
}

