/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.p3pp3rf1y.sophisticatedcore.crafting.ItemEnabledCondition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public class ShapelessBasedRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    @Nullable
    private final CompoundTag nbt;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    @Nullable
    private String group;

    public ShapelessBasedRecipeBuilder(ItemLike result, int count, @Nullable CompoundTag nbt) {
        this.result = result.m_5456_();
        this.count = count;
        this.nbt = nbt;
    }

    public static ShapelessBasedRecipeBuilder shapeless(ItemLike result) {
        return ShapelessBasedRecipeBuilder.shapeless(result, 1);
    }

    public static ShapelessBasedRecipeBuilder shapeless(ItemLike result, int count) {
        return new ShapelessBasedRecipeBuilder(result, count, null);
    }

    public static ShapelessBasedRecipeBuilder shapeless(ItemStack stack) {
        return new ShapelessBasedRecipeBuilder((ItemLike)stack.m_41720_(), 1, stack.m_41783_());
    }

    public ShapelessBasedRecipeBuilder condition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public ShapelessBasedRecipeBuilder requires(TagKey<Item> tag) {
        return this.requires(Ingredient.m_204132_(tag));
    }

    public ShapelessBasedRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public ShapelessBasedRecipeBuilder requires(ItemLike item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public ShapelessBasedRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public ShapelessBasedRecipeBuilder requires(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessBasedRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public ShapelessBasedRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_142700_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept(new Result(recipeId, this.result, this.conditions, this.nbt, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new ResourceLocation(recipeId.m_135827_(), "recipes/" + this.getGroup() + "/" + recipeId.m_135815_())));
    }

    private String getGroup() {
        return this.result.m_41471_() == null ? "" : this.result.m_41471_().m_40783_();
    }

    public static class Result
    implements FinishedRecipe {
        private final List<ICondition> conditions;
        private final ResourceLocation id;
        private final Item itemResult;
        @Nullable
        private final CompoundTag nbt;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item itemResult, List<ICondition> conditions, @Nullable CompoundTag nbt, int count, String group, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.itemResult = itemResult;
            this.conditions = conditions;
            this.nbt = nbt;
            this.count = count;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
            conditions.add(new ItemEnabledCondition(this.itemResult));
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray conditionsArray = new JsonArray();
            this.conditions.forEach(c -> conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conditionsArray);
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", RegistryHelper.getItemKey(this.itemResult).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            if (this.nbt != null) {
                jsonobject.addProperty("nbt", this.nbt.toString());
            }
            json.add("result", (JsonElement)jsonobject);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

