/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;

public class FluidFilterContainer {
    private final Player player;
    private final IServerUpdater serverUpdater;
    private final Supplier<FluidFilterLogic> fluidFilterLogic;
    private static final String DATA_FLUID = "setFluid";

    public FluidFilterContainer(Player player, IServerUpdater serverUpdater, Supplier<FluidFilterLogic> fluidFilterLogic) {
        this.player = player;
        this.serverUpdater = serverUpdater;
        this.fluidFilterLogic = fluidFilterLogic;
    }

    public Fluid getFluid(int index) {
        return this.fluidFilterLogic.get().getFluid(index);
    }

    private void setFluid(int index, Fluid fluid) {
        this.fluidFilterLogic.get().setFluid(index, fluid);
        this.serverUpdater.sendDataToServer(() -> this.serializeSetFluidData(index, fluid));
    }

    private CompoundTag serializeSetFluidData(int index, Fluid fluid) {
        CompoundTag ret = new CompoundTag();
        CompoundTag fluidNbt = new CompoundTag();
        fluidNbt.m_128405_("index", index);
        fluidNbt.m_128359_("fluid", fluid.getRegistryName().toString());
        ret.m_128365_(DATA_FLUID, (Tag)fluidNbt);
        return ret;
    }

    public boolean handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_FLUID)) {
            CompoundTag fluidData = data.m_128469_(DATA_FLUID);
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidData.m_128461_("fluid")));
            if (fluid != null) {
                this.setFluid(fluidData.m_128451_("index"), fluid);
            }
            return true;
        }
        return false;
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilterLogic.get().getNumberOfFluidFilters();
    }

    public void slotClick(int index) {
        ItemStack carried = this.player.f_36096_.m_142621_();
        if (carried.m_41619_()) {
            this.setFluid(index, Fluids.f_76191_);
            return;
        }
        carried.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(itemFluidHandler -> {
            FluidStack containedFluid = itemFluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!containedFluid.isEmpty()) {
                this.setFluid(index, containedFluid.getRawFluid());
            }
        });
    }
}

