/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraftforge.client.RenderProperties;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterRecipeContainer;

public class StonecutterRecipeControl
extends WidgetBase {
    private static final TextureBlitData SLIDER = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 131), Dimension.RECTANGLE_12_15);
    private static final TextureBlitData DISABLED_SLIDER = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 131), Dimension.RECTANGLE_12_15);
    private static final TextureBlitData RECIPE_BACKGROUND = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(110, 148), Dimension.RECTANGLE_16_18);
    private static final TextureBlitData SELECTED_RECIPE_BACKGROUND = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(110, 166), Dimension.RECTANGLE_16_18);
    private static final TextureBlitData RECIPE_BACKGROUND_HOVERED = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(110, 184), Dimension.RECTANGLE_16_18);
    private static final TextureBlitData LIST_BACKGROUND = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 146), new Dimension(81, 56));
    private static final int LIST_Y_OFFSET = 22;
    private static final int INPUT_SLOT_HEIGHT = 18;
    private static final int SPACING = 4;
    private boolean clickedOnScroll;
    private final StorageScreenBase<?> screen;
    private final StonecutterRecipeContainer container;
    private boolean hasItemsInInputSlot;
    private int recipeIndexOffset;
    private float sliderProgress;

    protected StonecutterRecipeControl(StorageScreenBase<?> screen, StonecutterRecipeContainer container, Position position) {
        super(position, new Dimension(81, 108));
        this.screen = screen;
        this.container = container;
        container.setInventoryUpdateListener(this::onInventoryUpdate);
        this.onInventoryUpdate();
    }

    public void moveSlotsToView() {
        Slot inputSlot = this.container.getInputSlot();
        inputSlot.f_40220_ = this.x + this.getCenteredX(16) - this.screen.getGuiLeft();
        inputSlot.f_40221_ = this.y - this.screen.getGuiTop() + 1;
        Slot outputSlot = this.container.getOutputSlot();
        outputSlot.f_40220_ = this.x + this.getCenteredX(16) - this.screen.getGuiLeft();
        outputSlot.f_40221_ = inputSlot.f_40221_ + 18 + 4 + LIST_BACKGROUND.getHeight() + 4 + 4;
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        GuiHelper.renderSlotsBackground(matrixStack, this.x + this.getCenteredX(18), this.y, 1, 1);
        GuiHelper.blit(matrixStack, this.x, this.y + 22, LIST_BACKGROUND);
        GuiHelper.blit(matrixStack, this.x + this.getCenteredX(26), this.y + 18 + 4 + LIST_BACKGROUND.getHeight() + 4, GuiHelper.CRAFTING_RESULT_SLOT);
        int sliderYOffset = (int)(39.0f * this.sliderProgress) + 1;
        GuiHelper.blit(matrixStack, this.x + 68, this.y + 22 + sliderYOffset, this.canScroll() ? SLIDER : DISABLED_SLIDER);
        int listInnerLeftX = this.x + 1;
        int listTopY = this.getListTopY();
        int recipeIndexOffsetMax = this.recipeIndexOffset + 12;
        this.renderRecipeBackgrounds(matrixStack, mouseX, mouseY, listInnerLeftX, listTopY, recipeIndexOffsetMax);
        this.drawRecipesItems(matrixStack, listInnerLeftX, listTopY, recipeIndexOffsetMax);
    }

    private void drawRecipesItems(PoseStack matrixStack, int listInnerLeftX, int top, int recipeIndexOffsetMax) {
        List<StonecutterRecipe> list = this.container.getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < this.container.getRecipeList().size(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = listInnerLeftX + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            GuiHelper.renderItemInGUI(matrixStack, this.minecraft, list.get(i).m_8043_(), k, i1);
        }
    }

    private int getListTopY() {
        return this.y + 22;
    }

    private void renderRecipeBackgrounds(PoseStack matrixStack, int mouseX, int mouseY, int listInnerLeftX, int listTopY, int recipeIndexOffsetMax) {
        for (int recipeIndex = this.recipeIndexOffset; recipeIndex < recipeIndexOffsetMax && recipeIndex < this.container.getRecipeList().size(); ++recipeIndex) {
            int j = recipeIndex - this.recipeIndexOffset;
            int recipeX = listInnerLeftX + j % 4 * 16;
            int row = j / 4;
            int recipeY = listTopY + row * 18 + 2;
            TextureBlitData background = RECIPE_BACKGROUND;
            if (recipeIndex == this.container.getSelectedRecipe()) {
                background = SELECTED_RECIPE_BACKGROUND;
            } else if (mouseX >= recipeX && mouseY >= recipeY && mouseX < recipeX + 16 && mouseY < recipeY + 18) {
                background = RECIPE_BACKGROUND_HOVERED;
            }
            GuiHelper.blit(matrixStack, recipeX, recipeY - 1, background);
        }
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && this.container.getRecipeList().size() > 12;
    }

    @Override
    protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void renderTooltip(Screen screen, PoseStack poseStack, int mouseX, int mouseY) {
        super.renderTooltip(screen, poseStack, mouseX, mouseY);
        this.renderHoveredTooltip(poseStack, mouseX, mouseY);
    }

    private void renderHoveredTooltip(PoseStack matrixStack, int mouseX, int mouseY) {
        if (this.hasItemsInInputSlot) {
            int listTopY = this.getListTopY();
            int k = this.recipeIndexOffset + 12;
            List<StonecutterRecipe> list = this.container.getRecipeList();
            for (int recipeIndex = this.recipeIndexOffset; recipeIndex < k && recipeIndex < list.size(); ++recipeIndex) {
                int inviewRecipeIndex = recipeIndex - this.recipeIndexOffset;
                int recipeLeftX = this.x + inviewRecipeIndex % 4 * 16;
                int k1 = listTopY + inviewRecipeIndex / 4 * 18 + 2;
                if (mouseX < recipeLeftX || mouseX >= recipeLeftX + 16 || mouseY < k1 || mouseY >= k1 + 18) continue;
                this.renderTooltip(matrixStack, list.get(recipeIndex).m_8043_(), mouseX, mouseY);
            }
        }
    }

    private void renderTooltip(PoseStack poseStack, ItemStack itemStack, int mouseX, int mouseY) {
        Font font = RenderProperties.get((ItemStack)itemStack).getFont(itemStack);
        this.screen.renderComponentTooltip(poseStack, this.screen.m_96555_(itemStack), mouseX, mouseY, font == null ? this.font : font);
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = this.container.hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        } else if (this.container.getSelectedRecipe() - this.recipeIndexOffset >= 12) {
            int rowsToScroll = (this.container.getSelectedRecipe() - this.recipeIndexOffset - 12) / 4 + 1;
            this.scrollRecipesByDelta(-rowsToScroll);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.clickedOnScroll = false;
        if (this.hasItemsInInputSlot) {
            int listInnerLeftX = this.x + 1;
            int listInnerTopY = this.y + 22 + 1;
            int maxRecipeIndexOffset = this.recipeIndexOffset + 12;
            for (int recipeIndex = this.recipeIndexOffset; recipeIndex < maxRecipeIndexOffset; ++recipeIndex) {
                int visibleRecipeIndex = recipeIndex - this.recipeIndexOffset;
                double relativeX = mouseX - (double)(listInnerLeftX + visibleRecipeIndex % 4 * 16);
                double relativeY = mouseY - (double)(listInnerTopY + Math.floorDiv(visibleRecipeIndex, 4) * 18);
                if (!(relativeX >= 0.0) || !(relativeY >= 0.0) || !(relativeX < 16.0) || !(relativeY < 18.0) || !this.container.selectRecipe(recipeIndex)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                return true;
            }
            int sliderLeftX = listInnerLeftX + 67;
            if (mouseX >= (double)sliderLeftX && mouseX < (double)(sliderLeftX + 12) && mouseY >= (double)listInnerTopY && mouseY < (double)(listInnerTopY + 54)) {
                this.clickedOnScroll = true;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnScroll && this.canScroll()) {
            int listTopY = this.y + 22;
            int listBottomY = listTopY + 54;
            this.sliderProgress = ((float)mouseY - (float)listTopY - 7.5f) / ((float)(listBottomY - listTopY) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            this.scrollRecipesByDelta(delta);
        }
        return true;
    }

    private void scrollRecipesByDelta(double delta) {
        int i = this.getHiddenRows();
        this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
        this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
        this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
    }

    protected int getHiddenRows() {
        return (this.container.getRecipeList().size() + 4 - 1) / 4 - 3;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

