/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.NameHelper;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketTeamIdSync;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamHelper;

public class TeamCommand {
    private static final TranslatableComponent CREATE_TEAM_SUCCESS = new TranslatableComponent("shetiphiancore.team.create.success");
    private static final TranslatableComponent CREATE_TEAM_FAIL_IN_TEAM = new TranslatableComponent("shetiphiancore.team.create.fail.inteam");
    private static final TranslatableComponent CREATE_TEAM_FAIL_EXISTS = new TranslatableComponent("shetiphiancore.team.create.fail.exists");
    private static final String RENAME_SUCCESS = "shetiphiancore.team.rename.success";
    private static final TranslatableComponent RENAME_FAIL = new TranslatableComponent("shetiphiancore.team.rename.fail.same");
    private static final TranslatableComponent SEND_INVITE_SUCCESS = new TranslatableComponent("shetiphiancore.team.invite.send.success");
    private static final TranslatableComponent SEND_INVITE_FAIL_ALREADY_MEMBER = new TranslatableComponent("shetiphiancore.team.invite.send.fail.member");
    private static final String SEND_INVITE_FAIL_PENDING = "shetiphiancore.team.invite.send.fail.pending";
    private static final String INVITE_NOTICE = "shetiphiancore.team.invite.receive.notice";
    private static final String ACCEPT_INVITE_SUCCESS = "shetiphiancore.team.invite.accept.success";
    private static final String ACCEPT_INVITE_SUCCESS_NOTICE = "shetiphiancore.team.invite.accept.success.notice";
    private static final TranslatableComponent ACCEPT_INVITE_FAIL_PERMISSIONS = new TranslatableComponent("shetiphiancore.team.invite.accept.fail.permissions");
    private static final TranslatableComponent ACCEPT_INVITE_FAIL_MEMBER = new TranslatableComponent("shetiphiancore.team.invite.accept.fail.member");
    private static final TranslatableComponent ACCEPT_INVITE_FAIL_IN_TEAM = new TranslatableComponent("shetiphiancore.team.invite.accept.fail.inteam");
    private static final TranslatableComponent ACCEPT_INVITE_FAIL_NO_INVITE = new TranslatableComponent("shetiphiancore.team.invite.accept.fail.noinvite");
    private static final TranslatableComponent LEAVE_SUCCESS = new TranslatableComponent("shetiphiancore.team.leave.success");
    private static final String LEAVE_SUCCESS_NOTICE = "shetiphiancore.team.leave.success.notice";
    private static final TranslatableComponent LEAVE_FAILED_LEADER = new TranslatableComponent("shetiphiancore.team.leave.fail.leader");
    private static final TranslatableComponent KICK_SUCCESS = new TranslatableComponent("shetiphiancore.team.kick.success");
    private static final TranslatableComponent KICK_SUCCESS_NOTICE = new TranslatableComponent("shetiphiancore.team.kick.success.notice");
    private static final TranslatableComponent KICK_FAIL_RANK = new TranslatableComponent("shetiphiancore.team.kick.fail.rank");
    private static final TranslatableComponent KICK_FAIL_WRONG_TEAM = new TranslatableComponent("shetiphiancore.team.kick.fail.team");
    private static final TranslatableComponent PROMOTE_SUCCESS = new TranslatableComponent("shetiphiancore.team.rank.promote.success");
    private static final TranslatableComponent PROMOTED = new TranslatableComponent("shetiphiancore.team.rank.promote.success.notice");
    private static final TranslatableComponent PROMOTE_FAIL_ALREADY_MANAGER = new TranslatableComponent("shetiphiancore.team.rank.promote.fail.manager");
    private static final TranslatableComponent PROMOTE_FAIL_USER_NOT_IN_TEAM = new TranslatableComponent("shetiphiancore.team.rank.promote.fail.not_member");
    private static final TranslatableComponent DEMOTE_SUCCESS = new TranslatableComponent("shetiphiancore.team.rank.demote.success");
    private static final TranslatableComponent DEMOTED = new TranslatableComponent("shetiphiancore.team.rank.demote.success.notice");
    private static final TranslatableComponent DEMOTE_SELF_SUCCESS = new TranslatableComponent("shetiphiancore.team.rank.demote.success.self");
    private static final TranslatableComponent TRANSFER_SUCCESS = new TranslatableComponent("shetiphiancore.team.transfer.success");
    private static final String TRANSFER_SUCCESS_NOTICE = "shetiphiancore.team.transfer.success.notice";
    private static final TranslatableComponent TRANSFER_FAIL_SELF = new TranslatableComponent("shetiphiancore.team.transfer.fail.self");
    private static final String DISBAND_SUCCESS = "shetiphiancore.team.disband.success";
    private static final TranslatableComponent DISBAND_FAIL_NOT_LEADER = new TranslatableComponent("shetiphiancore.team.disband.fail");
    private static final TranslatableComponent NO_TEAMS = new TranslatableComponent("shetiphiancore.team.no_teams");
    private static final TranslatableComponent TEAM_HAS_NO_MEMBERS = new TranslatableComponent("shetiphiancore.team.members.empty");
    private static final TranslatableComponent TEAM_DOESNT_EXIST = new TranslatableComponent("shetiphiancore.team.members.error.noteam");
    private static final TranslatableComponent YOUR_NOT_IN_A_TEAM = new TranslatableComponent("shetiphiancore.team.error.no_team");
    private static final TranslatableComponent YOUR_NOT_A_TEAM_MANAGER = new TranslatableComponent("shetiphiancore.team.error.not_manager.self");
    private static final TranslatableComponent PLAYER_NOT_A_TEAM_MANAGER = new TranslatableComponent("shetiphiancore.team.error.not_manager.other");
    private static final TranslatableComponent SYSADMIN_KICK_SUCCESS = new TranslatableComponent("shetiphiancore.team.sysadmin.kick.success");
    private static final String SYSADMIN_KICKED_FROM_TEAM = "shetiphiancore.team.sysadmin.kick.inform";
    private static final TranslatableComponent SYSADMIN_ADD_SUCCESS = new TranslatableComponent("shetiphiancore.team.sysadmin.add.success");
    private static final String SYSADMIN_ADDED_TO_TEAM = "shetiphiancore.team.sysadmin.add.inform";
    private static final TranslatableComponent SYSADMIN_TRANSFER_FAIL = new TranslatableComponent("shetiphiancore.team.sysadmin.transfer.fail");
    private static final TranslatableComponent SYSADMIN_DISBAND_SUCCESS = new TranslatableComponent("shetiphiancore.team.sysadmin.disband.success");
    private static final String SYSADMIN_TEAM_DISBANDED = "shetiphiancore.team.sysadmin.disband.inform";
    private static final Cache<ServerPlayer, Pair<PlayerTeam, Player>> INVITE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();

    public static void registerArguments() {
        ArgumentTypes.m_121601_((String)"shetiphiancore:team_string", TeamArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(TeamArgument::new));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spc_teams").then(Commands.m_82127_((String)"create").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"teamId", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> TeamCommand.createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId")))).then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId"), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName"))))))).then(Commands.m_82127_((String)"rename").then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.rename((CommandSourceStack)context.getSource(), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName")))))).then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.invite((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"accept").executes(context -> TeamCommand.accept((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"leave").executes(context -> TeamCommand.leave((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.kick((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"promote").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.promote((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"demote").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.demote((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.transfer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"disband").executes(context -> TeamCommand.disband((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"teams").executes(context -> TeamCommand.teams((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").executes(context -> TeamCommand.info((CommandSourceStack)context.getSource(), null))).then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.info((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spc_teams_sysadmin").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"create").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"teamId", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> TeamCommand.createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId")))).then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.sysadmin_createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId"), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName"))))))).then(Commands.m_82127_((String)"rename").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.sysadmin_rename((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName"))))))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"inform", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_kick((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"inform"))))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_add((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), EntityArgument.m_91477_((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_transfer((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), EntityArgument.m_91474_((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(Commands.m_82127_((String)"disband").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.sysadmin_disband((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"to-team").then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(context -> TeamCommand.teamMessage((CommandSourceStack)context.getSource(), MessageArgument.m_96835_((CommandContext)context, (String)"message")))));
    }

    private static int createTeam(CommandSourceStack source, ResourceLocation teamId) {
        return TeamCommand.createTeam(source, teamId, (Component)new TextComponent(teamId.m_135815_()));
    }

    private static int createTeam(CommandSourceStack source, ResourceLocation teamId, Component displayName) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            if (!TeamHelper.doesTeamExist(teamId.m_135815_())) {
                if (TeamHelper.getTeam((Player)executor) == null) {
                    PlayerTeam.create(teamId.m_135815_(), executor.m_142081_(), displayName);
                    source.m_81354_((Component)CREATE_TEAM_SUCCESS, false);
                } else {
                    source.m_81352_((Component)CREATE_TEAM_FAIL_IN_TEAM);
                }
            } else {
                source.m_81352_((Component)CREATE_TEAM_FAIL_EXISTS);
            }
        }
        return 0;
    }

    private static int rename(CommandSourceStack source, Component displayName) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_142081_())) {
                    Component oldName = eTeam.getDisplayName();
                    if (eTeam.changeDisplayName(displayName)) {
                        TranslatableComponent message = new TranslatableComponent(RENAME_SUCCESS, new Object[]{oldName, eTeam.getDisplayName()});
                        source.m_81354_((Component)message, false);
                    } else {
                        source.m_81352_((Component)RENAME_FAIL);
                    }
                } else {
                    source.m_81352_((Component)YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int invite(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_142081_())) {
                    Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
                    if (cachedInvite == null) {
                        if (!TeamHelper.getTeam(target.m_142081_()).equals(eTeam)) {
                            TranslatableComponent invite = new TranslatableComponent(INVITE_NOTICE, new Object[]{eTeam.getDisplayName(), "'/spc_teams accept'", 15});
                            target.m_6352_((Component)invite, Util.f_137441_);
                            INVITE_CACHE.put((Object)target, (Object)Pair.of((Object)eTeam, (Object)executor));
                            source.m_81354_((Component)SEND_INVITE_SUCCESS, false);
                        } else {
                            source.m_81352_((Component)SEND_INVITE_FAIL_ALREADY_MEMBER);
                        }
                    } else {
                        TranslatableComponent invite = new TranslatableComponent(SEND_INVITE_FAIL_PENDING, new Object[]{((PlayerTeam)cachedInvite.getLeft()).getDisplayName()});
                        target.m_6352_((Component)invite, Util.f_137441_);
                    }
                } else {
                    source.m_81352_((Component)YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int accept(CommandSourceStack source) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
            if (cachedInvite != null) {
                PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
                if (eTeam == null) {
                    PlayerTeam team = (PlayerTeam)cachedInvite.getLeft();
                    if (team.isManager(((Player)cachedInvite.getRight()).m_142081_())) {
                        TeamCommand.notifyTeam(source.m_81377_(), team.getMembers(), executor, true);
                        team.add(executor.m_142081_());
                        TranslatableComponent invite = new TranslatableComponent(ACCEPT_INVITE_SUCCESS, new Object[]{team.getDisplayName()});
                        source.m_81354_((Component)invite, false);
                    } else {
                        source.m_81352_((Component)ACCEPT_INVITE_FAIL_PERMISSIONS);
                    }
                } else if (eTeam.equals(cachedInvite.getLeft())) {
                    source.m_81352_((Component)ACCEPT_INVITE_FAIL_MEMBER);
                } else {
                    source.m_81352_((Component)ACCEPT_INVITE_FAIL_IN_TEAM);
                }
            } else {
                source.m_81352_((Component)ACCEPT_INVITE_FAIL_NO_INVITE);
            }
        }
        return 0;
    }

    private static int leave(CommandSourceStack source) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                UUID eId = executor.m_142081_();
                if (!eId.equals(eTeam.getLeader())) {
                    eTeam.leave(eId);
                    source.m_81354_((Component)LEAVE_SUCCESS, false);
                    TeamCommand.notifyTeam(source.m_81377_(), eTeam.getMembers(), executor, false);
                } else {
                    source.m_81352_((Component)LEAVE_FAILED_LEADER);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static void notifyTeam(MinecraftServer server, List<UUID> members, ServerPlayer player, boolean joining) {
        TranslatableComponent message = new TranslatableComponent(joining ? ACCEPT_INVITE_SUCCESS_NOTICE : LEAVE_SUCCESS_NOTICE, new Object[]{player.m_5446_()});
        server.m_6846_().m_11314_().forEach(arg_0 -> TeamCommand.lambda$notifyTeam$23(members, (MutableComponent)message, arg_0));
    }

    private static int kick(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                UUID eID = executor.m_142081_();
                if (eTeam.equals(TeamHelper.getTeam(target.m_142081_()))) {
                    if (eID.equals(eTeam.getLeader()) || eTeam.isManager(eID) && !eTeam.isManager(target.m_142081_())) {
                        eTeam.kick(target.m_142081_());
                        target.m_6352_((Component)KICK_SUCCESS_NOTICE, Util.f_137441_);
                        source.m_81354_((Component)KICK_SUCCESS, false);
                    } else {
                        source.m_81352_((Component)KICK_FAIL_RANK);
                    }
                } else {
                    source.m_81352_((Component)KICK_FAIL_WRONG_TEAM);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int promote(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_142081_())) {
                    if (eTeam.getMembers().contains(target.m_142081_())) {
                        if (eTeam.promote(target.m_142081_())) {
                            target.m_6352_((Component)PROMOTED, Util.f_137441_);
                            source.m_81354_((Component)PROMOTE_SUCCESS, false);
                        } else {
                            source.m_81352_((Component)PROMOTE_FAIL_ALREADY_MANAGER);
                        }
                    } else {
                        source.m_81352_((Component)PROMOTE_FAIL_USER_NOT_IN_TEAM);
                    }
                } else {
                    source.m_81352_((Component)YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int demote(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_142081_())) {
                    if (eTeam.demote(target.m_142081_())) {
                        if (executor.equals((Object)target)) {
                            source.m_81354_((Component)DEMOTE_SELF_SUCCESS, false);
                        } else {
                            target.m_6352_((Component)DEMOTED, Util.f_137441_);
                            source.m_81354_((Component)DEMOTE_SUCCESS, false);
                        }
                    } else {
                        source.m_81352_((Component)PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.m_81352_((Component)YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int transfer(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (executor.m_142081_().equals(eTeam.getLeader())) {
                    if (!eTeam.getManagers().contains(target.m_142081_())) {
                        if (eTeam.transfer(target.m_142081_())) {
                            TranslatableComponent message = new TranslatableComponent(TRANSFER_SUCCESS_NOTICE, new Object[]{eTeam.getDisplayName()});
                            target.m_6352_((Component)message, Util.f_137441_);
                            source.m_81354_((Component)TRANSFER_SUCCESS, false);
                        } else {
                            source.m_81352_((Component)TRANSFER_FAIL_SELF);
                        }
                    } else {
                        source.m_81352_((Component)PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.m_81352_((Component)YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int disband(CommandSourceStack source) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (executor.m_142081_().equals(eTeam.getLeader())) {
                    TranslatableComponent message = new TranslatableComponent(DISBAND_SUCCESS, new Object[]{eTeam.getDisplayName()});
                    List<UUID> players = TeamHelper.deleteTeam(eTeam.getId());
                    source.m_81377_().m_6846_().m_11314_().forEach(arg_0 -> TeamCommand.lambda$disband$24(players, (MutableComponent)message, arg_0));
                } else {
                    source.m_81352_((Component)DISBAND_FAIL_NOT_LEADER);
                }
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int teams(CommandSourceStack source) {
        Set<String> teams = TeamHelper.getTeams();
        if (!teams.isEmpty()) {
            TextComponent message = new TextComponent("\u00a77\u00a7o<teamId> ['<displayName>']\u00a7r");
            teams.forEach(id -> message.m_130946_("\u00a75 :: \u00a7f").m_130946_(id).m_130946_("\u00a77 ['\u00a7f").m_7220_(TeamHelper.getTeamDisplayName(id)).m_130946_("\u00a77']"));
            message.m_130946_("\u00a7r");
            source.m_81354_((Component)message, false);
            if (source.m_81377_().m_6992_() && source.m_81373_() instanceof ServerPlayer) {
                NetworkHandler.sendToPlayer(new PacketTeamIdSync(teams), (ServerPlayer)source.m_81373_());
            }
        } else {
            source.m_81352_((Component)NO_TEAMS);
        }
        return 0;
    }

    private static int info(CommandSourceStack source, String teamId) {
        Entity e;
        if (teamId == null && (e = source.m_81373_()) instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                teamId = eTeam.getId();
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
                return 0;
            }
        }
        if (TeamHelper.doesTeamExist(teamId)) {
            PlayerTeam eTeam = TeamHelper.getTeam(teamId);
            if (eTeam != null) {
                MutableComponent message = new TextComponent("\u00a7f").m_130946_(teamId).m_130946_("\u00a77 ['\u00a7f").m_7220_(eTeam.getDisplayName()).m_130946_("\u00a77']");
                List<UUID> members = eTeam.getMembers();
                if (!members.isEmpty()) {
                    UUID leader = eTeam.getLeader();
                    if (leader != null) {
                        message.m_130946_("\n");
                        message.m_130946_("|*| " + NameHelper.getLastKnownUsername(leader) + " |*|");
                    }
                    StringBuilder bldManagers = new StringBuilder();
                    eTeam.getManagers().forEach(manager -> {
                        if (manager != leader) {
                            bldManagers.append(NameHelper.getLastKnownUsername(manager)).append(", ");
                        }
                    });
                    if (bldManagers.length() > 0) {
                        String names = bldManagers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.m_130946_("\n");
                        message.m_130946_("|^| " + names + " |^|");
                    }
                    StringBuilder bldMembers = new StringBuilder();
                    members.forEach(member -> {
                        if (!eTeam.isManager((UUID)member)) {
                            bldMembers.append(NameHelper.getLastKnownUsername(member)).append(", ");
                        }
                    });
                    if (bldMembers.length() > 0) {
                        String names = bldMembers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.m_130946_("\n");
                        message.m_130946_(names);
                    }
                } else {
                    message.m_7220_((Component)TEAM_HAS_NO_MEMBERS);
                }
                source.m_81354_((Component)message, false);
            }
        } else {
            source.m_81352_((Component)TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_createTeam(CommandSourceStack source, ResourceLocation teamId, Component displayName) {
        if (!TeamHelper.doesTeamExist(teamId.m_135815_())) {
            PlayerTeam.create(teamId.m_135815_(), null, displayName);
            source.m_81354_((Component)CREATE_TEAM_SUCCESS, true);
        } else {
            source.m_81352_((Component)CREATE_TEAM_FAIL_EXISTS);
        }
        return 0;
    }

    private static int sysadmin_rename(CommandSourceStack source, String teamId, Component displayName) {
        PlayerTeam eTeam = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (eTeam != null) {
            Component oldName = eTeam.getDisplayName();
            if (eTeam.changeDisplayName(displayName)) {
                TranslatableComponent message = new TranslatableComponent(RENAME_SUCCESS, new Object[]{oldName, eTeam.getDisplayName()});
                source.m_81354_((Component)message, true);
            } else {
                source.m_81352_((Component)RENAME_FAIL);
            }
        } else {
            source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
        }
        return 0;
    }

    private static int sysadmin_kick(CommandSourceStack source, Collection<ServerPlayer> players, boolean inform) {
        players.forEach(player -> {
            PlayerTeam current = TeamHelper.getTeam((Player)player);
            if (current != null) {
                current.kick(player.m_142081_());
                if (inform) {
                    TranslatableComponent message = new TranslatableComponent(SYSADMIN_KICKED_FROM_TEAM, new Object[]{current.getDisplayName()});
                    player.m_6352_((Component)message, Util.f_137441_);
                }
                TeamCommand.notifyTeam(source.m_81377_(), current.getMembers(), player, false);
            }
        });
        source.m_81354_((Component)SYSADMIN_KICK_SUCCESS, true);
        return 0;
    }

    private static int sysadmin_add(CommandSourceStack source, String teamId, Collection<ServerPlayer> players, boolean force) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (team != null) {
            players.forEach(player -> {
                TranslatableComponent message;
                PlayerTeam current = TeamHelper.getTeam((Player)player);
                if (current != null && force) {
                    current.kick(player.m_142081_());
                    message = new TranslatableComponent(SYSADMIN_KICKED_FROM_TEAM, new Object[]{current.getDisplayName()});
                    player.m_6352_((Component)message, Util.f_137441_);
                    TeamCommand.notifyTeam(source.m_81377_(), team.getMembers(), player, false);
                    current = null;
                }
                if (current == null) {
                    TeamCommand.notifyTeam(source.m_81377_(), team.getMembers(), player, true);
                    team.add(player.m_142081_());
                    message = new TranslatableComponent(SYSADMIN_ADDED_TO_TEAM, new Object[]{team.getDisplayName()});
                    player.m_6352_((Component)message, Util.f_137441_);
                }
            });
            source.m_81354_((Component)SYSADMIN_ADD_SUCCESS, true);
        } else {
            source.m_81352_((Component)TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_transfer(CommandSourceStack source, String teamId, ServerPlayer player, boolean force) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (team != null) {
            TranslatableComponent message;
            PlayerTeam current = TeamHelper.getTeam((Player)player);
            if (current != null && force) {
                current.kick(player.m_142081_());
                message = new TranslatableComponent(SYSADMIN_KICKED_FROM_TEAM, new Object[]{current.getDisplayName()});
                player.m_6352_((Component)message, Util.f_137441_);
                current = null;
            }
            if (current == null) {
                if (team.transfer(player.m_142081_())) {
                    message = new TranslatableComponent(TRANSFER_SUCCESS_NOTICE, new Object[]{team.getDisplayName()});
                    player.m_6352_((Component)message, Util.f_137441_);
                    source.m_81354_((Component)TRANSFER_SUCCESS, true);
                } else {
                    source.m_81352_((Component)SYSADMIN_TRANSFER_FAIL);
                }
            }
        } else {
            source.m_81352_((Component)TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_disband(CommandSourceStack source, String teamId) {
        if (TeamHelper.doesTeamExist(teamId)) {
            TranslatableComponent message = new TranslatableComponent(SYSADMIN_TEAM_DISBANDED, new Object[]{TeamHelper.getTeamDisplayName(teamId)});
            List<UUID> players = TeamHelper.deleteTeam(teamId);
            source.m_81377_().m_6846_().m_11314_().forEach(arg_0 -> TeamCommand.lambda$sysadmin_disband$30(players, (MutableComponent)message, arg_0));
            source.m_81354_((Component)SYSADMIN_DISBAND_SUCCESS, true);
        } else {
            source.m_81352_((Component)TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int teamMessage(CommandSourceStack source, Component message) {
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerTeam team = TeamHelper.getTeam((Player)player);
            if (team != null) {
                String rank = player.m_142081_().equals(team.getLeader()) ? "|*| " : (team.getManagers().contains(player.m_142081_()) ? "|^| " : "");
                MutableComponent textComponent = new TextComponent("\u00a7a[team] " + rank).m_7220_(player.m_5446_()).m_130946_("\u00a7a: ").m_7220_(message);
                List<UUID> members = team.getMembers();
                source.m_81377_().m_6846_().m_11314_().forEach(arg_0 -> TeamCommand.lambda$teamMessage$31(members, (Component)textComponent, arg_0));
            } else {
                source.m_81352_((Component)YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static /* synthetic */ void lambda$teamMessage$31(List members, Component textComponent, ServerPlayer serverPlayer) {
        UUID uuid = serverPlayer.m_142081_();
        if (members.contains(uuid)) {
            serverPlayer.m_6352_(textComponent, uuid);
        }
    }

    private static /* synthetic */ void lambda$sysadmin_disband$30(List players, MutableComponent message, ServerPlayer serverPlayer) {
        UUID uuid = serverPlayer.m_142081_();
        if (players.contains(uuid)) {
            serverPlayer.m_6352_((Component)message, Util.f_137441_);
        }
    }

    private static /* synthetic */ void lambda$disband$24(List players, MutableComponent message, ServerPlayer serverPlayer) {
        UUID uuid = serverPlayer.m_142081_();
        if (players.contains(uuid)) {
            serverPlayer.m_6352_((Component)message, Util.f_137441_);
        }
    }

    private static /* synthetic */ void lambda$notifyTeam$23(List members, MutableComponent message, ServerPlayer serverPlayer) {
        if (members.contains(serverPlayer.m_142081_())) {
            serverPlayer.m_6352_((Component)message, Util.f_137441_);
        }
    }

    private static class TeamArgument
    implements ArgumentType<String> {
        private TeamArgument() {
        }

        public static String get(CommandContext<CommandSourceStack> context, String key) {
            return (String)context.getArgument(key, String.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82970_(TeamHelper.getTeams(), (SuggestionsBuilder)builder);
        }

        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }
    }
}

