/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.apiimpl.network.node.DetectorNetworkNode;
import com.refinedmods.refinedstorage.block.ColoredNetworkBlock;
import com.refinedmods.refinedstorage.blockentity.DetectorBlockEntity;
import com.refinedmods.refinedstorage.container.DetectorContainerMenu;
import com.refinedmods.refinedstorage.container.factory.BlockEntityMenuProvider;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.ColorMap;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class DetectorBlock
extends ColoredNetworkBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    private static final VoxelShape SHAPE = DetectorBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);

    public DetectorBlock() {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity instanceof DetectorBlockEntity && ((DetectorNetworkNode)((DetectorBlockEntity)blockEntity).getNode()).isPowered() ? 15 : 0;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ColorMap<DetectorBlock> colorMap = RSBlocks.DETECTOR;
        DyeColor color = DyeColor.getColor((ItemStack)player.m_21120_(hand));
        if (color != null && !state.m_60734_().equals(colorMap.get(color).get())) {
            BlockState newState = (BlockState)((DetectorBlock)((Object)colorMap.get(color).get())).m_49966_().m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)POWERED)));
            return RSBlocks.DETECTOR.setBlockState(newState, player.m_21120_(hand), level, pos, player);
        }
        if (!level.f_46443_) {
            return NetworkUtils.attemptModify(level, pos, player, () -> NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), new BlockEntityMenuProvider<DetectorBlockEntity>((Component)new TranslatableComponent("gui.refinedstorage.detector"), (blockEntity, windowId, inventory, p) -> new DetectorContainerMenu((DetectorBlockEntity)blockEntity, player, windowId), pos), (BlockPos)pos));
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DetectorBlockEntity(pos, state);
    }
}

