/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.apiimpl.network.node.diskdrive.DiskDriveNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IPrioritizable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import com.refinedmods.refinedstorage.util.LevelUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DiskDriveBlockEntity
extends NetworkNodeBlockEntity<DiskDriveNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, DiskDriveBlockEntity> PRIORITY = IPrioritizable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DiskDriveBlockEntity> COMPARE = IComparable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DiskDriveBlockEntity> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DiskDriveBlockEntity> TYPE = IType.createParameter();
    public static final BlockEntitySynchronizationParameter<AccessType, DiskDriveBlockEntity> ACCESS_TYPE = IAccessType.createParameter();
    public static final BlockEntitySynchronizationParameter<Long, DiskDriveBlockEntity> STORED = new BlockEntitySynchronizationParameter<Long, DiskDriveBlockEntity>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long stored = 0L;
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getItemDisks()) {
            if (storage == null) continue;
            stored += (long)storage.getStored();
        }
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getFluidDisks()) {
            if (storage == null) continue;
            stored += (long)storage.getStored();
        }
        return stored;
    });
    public static final BlockEntitySynchronizationParameter<Long, DiskDriveBlockEntity> CAPACITY = new BlockEntitySynchronizationParameter<Long, DiskDriveBlockEntity>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long capacity = 0L;
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getItemDisks()) {
            if (storage == null) continue;
            if (storage.getCapacity() == -1) {
                return -1L;
            }
            capacity += (long)storage.getCapacity();
        }
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getFluidDisks()) {
            if (storage == null) continue;
            if (storage.getCapacity() == -1) {
                return -1L;
            }
            capacity += (long)storage.getCapacity();
        }
        return capacity;
    });
    public static final ModelProperty<DiskState[]> DISK_STATE_PROPERTY = new ModelProperty();
    private static final String NBT_DISK_STATE = "DiskStates";
    private final LazyOptional<IItemHandler> diskCapability = LazyOptional.of(() -> ((DiskDriveNetworkNode)this.getNode()).getDisks());
    private final DiskState[] diskState = new DiskState[8];

    public DiskDriveBlockEntity(BlockPos pos, BlockState state) {
        super(RSBlockEntities.DISK_DRIVE, pos, state, DiskDriveNetworkNode.class);
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        Arrays.fill((Object[])this.diskState, (Object)DiskState.NONE);
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        super.writeUpdate(tag);
        ListTag list = new ListTag();
        for (DiskState state : ((DiskDriveNetworkNode)this.getNode()).getDiskState()) {
            list.add((Object)IntTag.m_128679_((int)state.ordinal()));
        }
        tag.m_128365_(NBT_DISK_STATE, (Tag)list);
        return tag;
    }

    @Override
    public void readUpdate(CompoundTag tag) {
        super.readUpdate(tag);
        ListTag list = tag.m_128437_(NBT_DISK_STATE, 3);
        for (int i = 0; i < list.size(); ++i) {
            this.diskState[i] = DiskState.values()[list.m_128763_(i)];
        }
        this.requestModelDataUpdate();
        LevelUtils.updateBlock(this.f_58857_, this.f_58858_);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DISK_STATE_PROPERTY, (Object)this.diskState).build();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.diskCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    @Nonnull
    public DiskDriveNetworkNode createNode(Level level, BlockPos pos) {
        return new DiskDriveNetworkNode(level, pos);
    }
}

