/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.apiimpl.network.node.FluidInterfaceNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidInterfaceBlockEntity
extends NetworkNodeBlockEntity<FluidInterfaceNetworkNode> {
    public static final BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity> TANK_IN = new BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity>(RSSerializers.FLUID_STACK_SERIALIZER, FluidStack.EMPTY, t -> ((FluidInterfaceNetworkNode)t.getNode()).getTankIn().getFluid());
    public static final BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity> TANK_OUT = new BlockEntitySynchronizationParameter<FluidStack, FluidInterfaceBlockEntity>(RSSerializers.FLUID_STACK_SERIALIZER, FluidStack.EMPTY, t -> ((FluidInterfaceNetworkNode)t.getNode()).getTankOut().getFluid());
    private final LazyOptional<IFluidHandler> tankCapability = LazyOptional.of(() -> ((FluidInterfaceNetworkNode)this.getNode()).getTank());
    private final LazyOptional<IItemHandler> inCapability = LazyOptional.of(() -> ((FluidInterfaceNetworkNode)this.getNode()).getIn());

    public FluidInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(RSBlockEntities.FLUID_INTERFACE, pos, state, FluidInterfaceNetworkNode.class);
        this.dataManager.addParameter(TANK_IN);
        this.dataManager.addParameter(TANK_OUT);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inCapability.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    @Nonnull
    public FluidInterfaceNetworkNode createNode(Level level, BlockPos pos) {
        return new FluidInterfaceNetworkNode(level, pos);
    }
}

