/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IPrioritizable;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FluidStorageBlockEntity
extends NetworkNodeBlockEntity<FluidStorageNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, FluidStorageBlockEntity> PRIORITY = IPrioritizable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, FluidStorageBlockEntity> COMPARE = IComparable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, FluidStorageBlockEntity> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final BlockEntitySynchronizationParameter<AccessType, FluidStorageBlockEntity> ACCESS_TYPE = IAccessType.createParameter();
    public static final BlockEntitySynchronizationParameter<Long, FluidStorageBlockEntity> STORED = new BlockEntitySynchronizationParameter<Long, FluidStorageBlockEntity>(RSSerializers.LONG_SERIALIZER, 0L, t -> ((FluidStorageNetworkNode)t.getNode()).getStorage() != null ? (long)((FluidStorageNetworkNode)t.getNode()).getStorage().getStored() : 0L);
    private final FluidStorageType type;

    public FluidStorageBlockEntity(FluidStorageType type, BlockPos pos, BlockState state) {
        super(FluidStorageBlockEntity.getType(type), pos, state, FluidStorageNetworkNode.class);
        this.type = type;
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    public static BlockEntityType<FluidStorageBlockEntity> getType(FluidStorageType type) {
        switch (type) {
            case SIXTY_FOUR_K: {
                return RSBlockEntities.SIXTY_FOUR_K_FLUID_STORAGE_BLOCK;
            }
            case TWO_HUNDRED_FIFTY_SIX_K: {
                return RSBlockEntities.TWO_HUNDRED_FIFTY_SIX_K_FLUID_STORAGE_BLOCK;
            }
            case THOUSAND_TWENTY_FOUR_K: {
                return RSBlockEntities.THOUSAND_TWENTY_FOUR_K_FLUID_STORAGE_BLOCK;
            }
            case FOUR_THOUSAND_NINETY_SIX_K: {
                return RSBlockEntities.FOUR_THOUSAND_NINETY_SIX_K_FLUID_STORAGE_BLOCK;
            }
            case CREATIVE: {
                return RSBlockEntities.CREATIVE_FLUID_STORAGE_BLOCK;
            }
        }
        throw new IllegalArgumentException("Unknown storage type " + type);
    }

    public FluidStorageType getFluidStorageType() {
        return this.type;
    }

    @Override
    @Nonnull
    public FluidStorageNetworkNode createNode(Level level, BlockPos pos) {
        return new FluidStorageNetworkNode(level, pos, this.type);
    }
}

