/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RSContainerMenus;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExporterNetworkNode;
import com.refinedmods.refinedstorage.blockentity.ExporterBlockEntity;
import com.refinedmods.refinedstorage.container.BaseContainerMenu;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ExporterContainerMenu
extends BaseContainerMenu {
    private final ExporterBlockEntity exporter;
    private boolean hasRegulatorMode;

    public ExporterContainerMenu(ExporterBlockEntity exporter, Player player, int windowId) {
        super(RSContainerMenus.EXPORTER, exporter, player, windowId);
        this.exporter = exporter;
        this.hasRegulatorMode = this.hasRegulatorMode();
        this.initSlots();
    }

    private boolean hasRegulatorMode() {
        return ((ExporterNetworkNode)this.exporter.getNode()).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        boolean updatedHasRegulatorMode = this.hasRegulatorMode();
        if (this.hasRegulatorMode != updatedHasRegulatorMode) {
            this.hasRegulatorMode = updatedHasRegulatorMode;
            this.initSlots();
        }
    }

    public void initSlots() {
        int i;
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.transferManager.clearTransfers();
        for (i = 0; i < 4; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)((ExporterNetworkNode)this.exporter.getNode()).getUpgrades(), i, 187, 6 + i * 18));
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new FilterSlot((IItemHandler)((ExporterNetworkNode)this.exporter.getNode()).getItemFilters(), i, 8 + 18 * i, 20, ((ExporterNetworkNode)this.exporter.getNode()).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR) ? 1 : 0).setEnableHandler(() -> ((ExporterNetworkNode)this.exporter.getNode()).getType() == 0));
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new FluidFilterSlot(((ExporterNetworkNode)this.exporter.getNode()).getFluidFilters(), i, 8 + 18 * i, 20, ((ExporterNetworkNode)this.exporter.getNode()).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR) ? 1 : 0).setEnableHandler(() -> ((ExporterNetworkNode)this.exporter.getNode()).getType() == 1));
        }
        this.addPlayerInventory(8, 55);
        this.transferManager.addBiTransfer((Container)this.getPlayer().m_150109_(), (IItemHandler)((ExporterNetworkNode)this.exporter.getNode()).getUpgrades());
        this.transferManager.addFilterTransfer((Container)this.getPlayer().m_150109_(), ((ExporterNetworkNode)this.exporter.getNode()).getItemFilters(), ((ExporterNetworkNode)this.exporter.getNode()).getFluidFilters(), ((ExporterNetworkNode)this.exporter.getNode())::getType);
    }
}

