/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class UpgradeItem
extends Item {
    private final Type type;

    public UpgradeItem(Type type) {
        super(new Item.Properties().m_41491_(RS.CREATIVE_MODE_TAB));
        this.type = type;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.type.getFortuneLevel() > 0) {
            tooltip.add((Component)new TranslatableComponent("enchantment.minecraft.fortune").m_130946_(" ").m_7220_((Component)new TranslatableComponent("enchantment.level." + this.type.getFortuneLevel())).m_6270_(Styles.GRAY));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return this.type == Type.SILK_TOUCH || this.type == Type.FORTUNE_1 || this.type == Type.FORTUNE_2 || this.type == Type.FORTUNE_3;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        NORMAL("normal"),
        SPEED("speed"),
        RANGE("range"),
        CRAFTING("crafting"),
        STACK("stack"),
        SILK_TOUCH("silk_touch"),
        FORTUNE_1("fortune_1"),
        FORTUNE_2("fortune_2"),
        FORTUNE_3("fortune_3"),
        REGULATOR("regulator");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getEnergyUsage() {
            switch (this) {
                case NORMAL: {
                    return 0;
                }
                case RANGE: {
                    return RS.SERVER_CONFIG.getUpgrades().getRangeUpgradeUsage();
                }
                case SPEED: {
                    return RS.SERVER_CONFIG.getUpgrades().getSpeedUpgradeUsage();
                }
                case CRAFTING: {
                    return RS.SERVER_CONFIG.getUpgrades().getCraftingUpgradeUsage();
                }
                case STACK: {
                    return RS.SERVER_CONFIG.getUpgrades().getStackUpgradeUsage();
                }
                case SILK_TOUCH: {
                    return RS.SERVER_CONFIG.getUpgrades().getSilkTouchUpgradeUsage();
                }
                case FORTUNE_1: {
                    return RS.SERVER_CONFIG.getUpgrades().getFortune1UpgradeUsage();
                }
                case FORTUNE_2: {
                    return RS.SERVER_CONFIG.getUpgrades().getFortune2UpgradeUsage();
                }
                case FORTUNE_3: {
                    return RS.SERVER_CONFIG.getUpgrades().getFortune3UpgradeUsage();
                }
                case REGULATOR: {
                    return RS.SERVER_CONFIG.getUpgrades().getRegulatorUpgradeUsage();
                }
            }
            throw new IllegalStateException("What even am I?");
        }

        public int getFortuneLevel() {
            switch (this) {
                case FORTUNE_1: {
                    return 1;
                }
                case FORTUNE_2: {
                    return 2;
                }
                case FORTUNE_3: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

