/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.render.model.DelegateBakedModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class FullbrightBakedModel
extends DelegateBakedModel {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            return FullbrightBakedModel.transformQuads(key.base.getQuads(key.state, key.side, key.random, (IModelData)EmptyModelData.INSTANCE), key.textures);
        }
    });
    private final Set<ResourceLocation> textures;
    private final boolean doCaching;

    public FullbrightBakedModel(BakedModel base, boolean doCaching, ResourceLocation ... textures) {
        super(base);
        this.textures = new HashSet<ResourceLocation>(Arrays.asList(textures));
        this.doCaching = doCaching;
    }

    public static void invalidateCache() {
        CACHE.invalidateAll();
    }

    private static List<BakedQuad> transformQuads(List<BakedQuad> oldQuads, Set<ResourceLocation> textures) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(oldQuads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (!textures.contains(quad.m_173410_().m_118413_())) continue;
            quads.set(i, FullbrightBakedModel.transformQuad(quad));
        }
        return quads;
    }

    private static BakedQuad transformQuad(BakedQuad quad) {
        int[] vertexData = (int[])quad.m_111303_().clone();
        int step = vertexData.length / 4;
        vertexData[6] = 0xF000F0;
        vertexData[6 + step] = 0xF000F0;
        vertexData[6 + 2 * step] = 0xF000F0;
        vertexData[6 + 3 * step] = 0xF000F0;
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        if (state == null) {
            return this.base.getQuads(state, side, rand, data);
        }
        if (!this.doCaching) {
            return FullbrightBakedModel.transformQuads(this.base.getQuads(state, side, rand, data), this.textures);
        }
        return (List)CACHE.getUnchecked((Object)new CacheKey(this.base, this.textures, rand, state, side));
    }

    private static class CacheKey {
        private final BakedModel base;
        private final Set<ResourceLocation> textures;
        private final Random random;
        private final BlockState state;
        private final Direction side;

        public CacheKey(BakedModel base, Set<ResourceLocation> textures, Random random, BlockState state, Direction side) {
            this.base = base;
            this.textures = textures;
            this.random = random;
            this.state = state;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (cacheKey.side != this.side) {
                return false;
            }
            return this.state.equals(cacheKey.state);
        }

        public int hashCode() {
            return this.state.hashCode() + 31 * (this.side != null ? this.side.hashCode() : 0);
        }
    }
}

