/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.sorting;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.screen.grid.sorting.IGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.SortingDirection;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IdGridSorter
implements IGridSorter {
    @Override
    public boolean isApplicable(IGrid grid) {
        return grid.getSortingType() == 2;
    }

    @Override
    public int compare(IGridStack left, IGridStack right, SortingDirection sortingDirection) {
        int leftId = 0;
        int rightId = 0;
        if (left.getIngredient() instanceof ItemStack && right.getIngredient() instanceof ItemStack) {
            leftId = Item.m_41393_((Item)((ItemStack)left.getIngredient()).m_41720_());
            rightId = Item.m_41393_((Item)((ItemStack)right.getIngredient()).m_41720_());
        } else if (left.getIngredient() instanceof FluidStack && right.getIngredient() instanceof FluidStack) {
            leftId = Registry.f_122822_.m_7447_((Object)((FluidStack)left.getIngredient()).getFluid());
            rightId = Registry.f_122822_.m_7447_((Object)((FluidStack)right.getIngredient()).getFluid());
        }
        if (leftId != rightId) {
            if (sortingDirection == SortingDirection.DESCENDING) {
                return Integer.compare(leftId, rightId);
            }
            if (sortingDirection == SortingDirection.ASCENDING) {
                return Integer.compare(rightId, leftId);
            }
        }
        return 0;
    }
}

