/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import owmii.powah.EnvHandler;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.item.ReactorItem;
import owmii.powah.lib.block.AbstractGeneratorBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.client.wiki.page.panel.InfoBox;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.inventory.AbstractContainer;
import owmii.powah.lib.util.Util;

public class ReactorBlock
extends AbstractGeneratorBlock<ReactorBlock> {
    public static final BooleanProperty CORE = BooleanProperty.m_61465_((String)"core");

    public ReactorBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties.m_60922_((state, blockGetter, blockPos, entityType) -> false), variant);
        this.setStateProps(state -> (BlockState)state.m_61124_((Property)CORE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable CreativeModeTab group) {
        return new ReactorItem(this, properties, group);
    }

    @Override
    public GeneratorConfig getConfig() {
        return Powah.config().generators.reactors;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)CORE)).booleanValue()) {
            return new ReactorTile(pos, state, (Tier)this.variant);
        }
        return new ReactorPartTile(pos, state, (Tier)this.variant);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return context.m_43723_() != null ? (BlockState)this.m_49966_().m_61124_((Property)CORE, (Comparable)Boolean.valueOf(true)) : super.m_5573_(context);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ReactorPartTile reactor;
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile reactor2 = (ReactorTile)tileentity;
            if (reactor2.isBuilt()) {
                if (EnvHandler.INSTANCE.interactWithTank(player, hand, reactor2.getTank())) {
                    reactor2.sync();
                    return InteractionResult.SUCCESS;
                }
                return super.m_6227_(state, world, pos, player, hand, result);
            }
        } else if (tileentity instanceof ReactorPartTile && (reactor = (ReactorPartTile)tileentity).isBuilt() && reactor.core().isPresent()) {
            return ((ReactorBlock)reactor.getBlock()).m_6227_(state, world, reactor.getCorePos(), player, hand, result);
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }

    @Override
    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof ReactorTile) {
            return new ReactorContainer(id, inventory, (ReactorTile)te);
        }
        return null;
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile tile = (ReactorTile)tileentity;
            tile.demolish(world);
        } else if (tileentity instanceof ReactorPartTile) {
            ReactorPartTile tile = (ReactorPartTile)tileentity;
            tile.demolish(world);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CORE});
    }

    @Override
    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("info.powah.generation.factor").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Text.COLON).m_7220_((Component)new TextComponent(Util.numFormat(this.getConfig().getGeneration((Tier)this.variant))).m_7220_((Component)new TranslatableComponent("info.lollipop.fe.pet.tick")).m_130940_(ChatFormatting.DARK_GRAY)));
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, energy -> {
            box.set((BaseComponent)new TranslatableComponent("info.lollipop.capacity"), (BaseComponent)new TranslatableComponent("info.lollipop.fe", new Object[]{Util.addCommas(energy.getCapacity())}));
            box.set((BaseComponent)new TranslatableComponent("info.powah.generation.factor"), (BaseComponent)new TranslatableComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas(this.getConfig().getGeneration((Tier)this.variant))}));
            box.set((BaseComponent)new TranslatableComponent("info.lollipop.max.extract"), (BaseComponent)new TranslatableComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas(energy.getMaxExtract())}));
        });
        return box;
    }
}

