/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import owmii.powah.api.PowahAPI;

public class HeatSourceCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", "heat.sources");
    private final IDrawable background;
    private final IDrawable icon;

    public HeatSourceCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Blocks.f_50450_));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.powah.jei.category.heat.sources");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        if (recipe.block != null) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.block);
        }
        if (recipe.fluid != null) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(recipe.fluid, 1000));
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        if (recipe.fluid == null) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 3, 4);
            itemStacks.set(ingredients);
        } else {
            IGuiFluidStackGroup fluidStack = iRecipeLayout.getFluidStacks();
            fluidStack.init(0, true, 4, 5);
            fluidStack.set(ingredients);
        }
    }

    public void draw(Recipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, ChatFormatting.DARK_GRAY + I18n.m_118938_((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + ChatFormatting.RESET + I18n.m_118938_((String)"info.lollipop.temperature.c", (Object[])new Object[]{recipe.heat}), 30.0f, 9.0f, 12858368);
    }

    public static List<Recipe> getRecipes(IIngredientManager ingredientManager) {
        Collection allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Map.Entry entry : Registry.f_122824_.m_6579_()) {
            ResourceLocation blockId;
            Integer heat;
            Item blockItem = Item.m_41439_((Block)((Block)entry.getValue()));
            if (blockItem == Items.f_41852_ || (heat = PowahAPI.HEAT_SOURCES.getOrDefault(blockId = ((ResourceKey)entry.getKey()).m_135782_(), 0)) == 0) continue;
            recipes.add(new Recipe(blockItem.m_7968_(), null, heat));
        }
        for (Map.Entry entry : Registry.f_122822_.m_6579_()) {
            ResourceLocation fluidId = ((ResourceKey)entry.getKey()).m_135782_();
            Integer heat = PowahAPI.HEAT_SOURCES.getOrDefault(fluidId, 0);
            if (heat == 0) continue;
            recipes.add(new Recipe(null, (Fluid)entry.getValue(), heat));
        }
        recipes.sort(Comparator.comparingInt(Recipe::heat));
        return recipes;
    }

    public record Recipe(@Nullable ItemStack block, @Nullable Fluid fluid, int heat) {
    }
}

