/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import owmii.powah.lib.util.math.V3d;

public class Cube {
    private final PoseStack matrix;
    private final VertexConsumer builder;
    private Set<Side> sides = new HashSet<Side>();
    private V3d pos = V3d.ZERO;
    private double size = 1.0;
    private float r = 1.0f;
    private float b = 1.0f;
    private float g = 1.0f;
    private float a = 1.0f;
    private int light;

    Cube(PoseStack matrix, VertexConsumer builder) {
        this.matrix = matrix;
        this.builder = builder;
    }

    public static Cube create(PoseStack stack, VertexConsumer builder) {
        return new Cube(stack, builder);
    }

    public Cube size(double size) {
        this.size = size;
        return this;
    }

    public Cube pos(double x, double y, double z) {
        return this.pos(new V3d(x, y, z));
    }

    public Cube pos(V3d pos) {
        this.pos = pos;
        return this;
    }

    public Cube bright() {
        this.light(0xF000F0);
        return this;
    }

    public Cube light(int light) {
        this.light = light;
        return this;
    }

    public Cube side(BlockState state) {
        this.sides.add(Side.from((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        return this;
    }

    public Cube side(Direction side) {
        this.sides.add(Side.from(side));
        return this;
    }

    public Cube side(Side side) {
        this.sides.add(side);
        return this;
    }

    public Cube color(int color) {
        return this.color((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public Cube color(float r, float g, float b) {
        return this.color(r, g, b, 1.0f);
    }

    public Cube color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public Cube alpha(float alpha) {
        this.a = alpha;
        return this;
    }

    public void draw(TextureAtlasSprite sprite) {
        float d = (float)(this.size / 2.0);
        Matrix4f matrix4f = this.matrix.m_85850_().m_85861_();
        boolean isAll = this.sides.isEmpty();
        if (isAll || this.sides.contains((Object)Side.UP)) {
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
        }
        if (isAll || this.sides.contains((Object)Side.DOWN)) {
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
        }
        if (isAll || this.sides.contains((Object)Side.NORTH)) {
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
        }
        if (isAll || this.sides.contains((Object)Side.SOUTH)) {
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
        }
        if (isAll || this.sides.contains((Object)Side.WEST)) {
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() - d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
        }
        if (isAll || this.sides.contains((Object)Side.EAST)) {
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() - d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() + d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(this.light).m_5752_();
            this.builder.m_85982_(matrix4f, (float)this.pos.m_7096_() + d, (float)this.pos.m_7098_() - d, (float)this.pos.m_7094_() + d).m_85950_(this.r, this.g, this.b, this.a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(this.light).m_5752_();
        }
    }

    public static enum Side {
        ALL,
        DOWN,
        UP,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public static Side from(Direction side) {
            return Side.values()[side.ordinal() + 1];
        }
    }
}

