/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.RetexturedHelper;

public class DefaultRetexturedBlockEntity
extends MantleBlockEntity
implements IRetexturedBlockEntity {
    private final Lazy<IModelData> data = Lazy.of(this::getRetexturedModelData);
    @Nonnull
    private Block texture = Blocks.f_50016_;

    public DefaultRetexturedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nonnull
    public IModelData getModelData() {
        return (IModelData)this.data.get();
    }

    @Override
    public String getTextureName() {
        return RetexturedHelper.getTextureName(this.texture);
    }

    @Override
    public void updateTexture(String name) {
        Block oldTexture = this.texture;
        this.texture = RetexturedHelper.getBlock(name);
        if (oldTexture != this.texture) {
            this.setChangedFast();
            RetexturedHelper.onTextureUpdated(this);
        }
    }

    @Override
    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    @Override
    protected void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        if (this.texture != Blocks.f_50016_) {
            tags.m_128359_("texture", this.getTextureName());
        }
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128425_("texture", 8)) {
            this.texture = RetexturedHelper.getBlock(tags.m_128461_("texture"));
            RetexturedHelper.onTextureUpdated(this);
        }
    }

    @Override
    @Nonnull
    public Block getTexture() {
        return this.texture;
    }
}

