/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.mantle.util.ItemStackList;

public abstract class InventoryBlockEntity
extends NameableBlockEntity
implements Container,
MenuProvider,
Nameable {
    private static final String TAG_INVENTORY_SIZE = "InventorySize";
    private static final String TAG_ITEMS = "Items";
    private static final String TAG_SLOT = "Slot";
    private NonNullList<ItemStack> inventory;
    private final boolean saveSizeToNBT;
    protected int stackSizeLimit;
    protected IItemHandlerModifiable itemHandler;
    protected LazyOptional<IItemHandlerModifiable> itemHandlerCap;

    public InventoryBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, Component name, boolean saveSizeToNBT, int inventorySize) {
        this(tileEntityTypeIn, pos, state, name, saveSizeToNBT, inventorySize, 64);
    }

    public InventoryBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, Component name, boolean saveSizeToNBT, int inventorySize, int maxStackSize) {
        super(tileEntityTypeIn, pos, state, name);
        this.saveSizeToNBT = saveSizeToNBT;
        this.inventory = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
        this.stackSizeLimit = maxStackSize;
        this.itemHandler = new InvWrapper((Container)this);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCap.invalidate();
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.inventory.get(slot);
    }

    public boolean isStackInSlot(int slot) {
        return !this.m_8020_(slot).m_41619_();
    }

    private void resizeInternal(int size) {
        if (size == this.inventory.size()) {
            return;
        }
        ItemStackList newInventory = ItemStackList.withSize(size);
        for (int i = 0; i < size && i < this.inventory.size(); ++i) {
            newInventory.set(i, (ItemStack)this.inventory.get(i));
        }
        this.inventory = newInventory;
    }

    public void resize(int size) {
        this.resizeInternal(size);
        this.setChangedFast();
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public int m_6893_() {
        return this.stackSizeLimit;
    }

    public void m_6836_(int slot, ItemStack itemstack) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return;
        }
        ItemStack current = (ItemStack)this.inventory.get(slot);
        this.inventory.set(slot, (Object)itemstack);
        if (!itemstack.m_41619_() && itemstack.m_41613_() > this.m_6893_()) {
            itemstack.m_41764_(this.m_6893_());
        }
        if (!ItemStack.m_41728_((ItemStack)current, (ItemStack)itemstack)) {
            this.setChangedFast();
        }
    }

    public ItemStack m_7407_(int slot, int quantity) {
        if (quantity <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.m_8020_(slot);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (itemStack.m_41613_() <= quantity) {
            this.m_6836_(slot, ItemStack.f_41583_);
            this.setChangedFast();
            return itemStack;
        }
        itemStack = itemStack.m_41620_(quantity);
        if (this.m_8020_(slot).m_41613_() == 0) {
            this.m_6836_(slot, ItemStack.f_41583_);
        }
        this.setChangedFast();
        return itemStack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack itemStack = this.m_8020_(slot);
        this.m_6836_(slot, ItemStack.f_41583_);
        return itemStack;
    }

    public boolean m_7013_(int slot, ItemStack itemstack) {
        if (slot < this.m_6643_()) {
            return ((ItemStack)this.inventory.get(slot)).m_41619_() || itemstack.m_41613_() + ((ItemStack)this.inventory.get(slot)).m_41613_() <= this.m_6893_();
        }
        return false;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public boolean m_6542_(Player entityplayer) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this || this.m_58900_().m_60734_() == Blocks.f_50016_) {
            return false;
        }
        return entityplayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    @Override
    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (this.saveSizeToNBT) {
            this.resizeInternal(tags.m_128451_(TAG_INVENTORY_SIZE));
        }
        this.readInventoryFromNBT(tags);
    }

    @Override
    public void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        if (this.saveSizeToNBT) {
            tags.m_128405_(TAG_INVENTORY_SIZE, this.inventory.size());
        }
    }

    @Override
    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        this.writeInventoryToNBT(tags);
    }

    public void writeInventoryToNBT(CompoundTag tag) {
        InventoryBlockEntity inventory = this;
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_(TAG_SLOT, (byte)i);
            inventory.m_8020_(i).m_41739_(itemTag);
            nbttaglist.add((Object)itemTag);
        }
        tag.m_128365_(TAG_ITEMS, (Tag)nbttaglist);
    }

    public void readInventoryFromNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        int limit = this.m_6893_();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.m_128728_(i);
            int slot = itemTag.m_128445_(TAG_SLOT) & 0xFF;
            if (slot >= this.inventory.size()) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
            if (!stack.m_41619_() && stack.m_41613_() > limit) {
                stack.m_41764_(limit);
            }
            this.inventory.set(slot, (Object)stack);
        }
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }
}

