/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.RegistryArgument;
import slimeknights.mantle.command.ViewTagCommand;

public class DumpTagCommand {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Dynamic2CommandExceptionType ERROR_READING_TAG = new Dynamic2CommandExceptionType((type, name) -> new TranslatableComponent("command.mantle.dump_tag.read_error", new Object[]{type, name}));
    private static final Component SUCCESS_LOG = new TranslatableComponent("command.mantle.dump_tag.success_log");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).then(Commands.m_82129_((String)"type", RegistryArgument.registry()).suggests(MantleCommand.REGISTRY).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleCommand.VALID_TAGS).executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"log").executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, false)))).then(Commands.m_82127_((String)"save").executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, true)))));
    }

    private static int run(CommandContext<CommandSourceStack> context, boolean saveFile) throws CommandSyntaxException {
        return DumpTagCommand.runGeneric(context, RegistryArgument.getResult(context, "type"), saveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> int runGeneric(CommandContext<CommandSourceStack> context, Registry<T> registry, boolean saveFile) throws CommandSyntaxException {
        ResourceLocation regName = registry.m_123023_().m_135782_();
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        ResourceManager manager = ((CommandSourceStack)context.getSource()).m_81377_().m_177941_();
        ResourceLocation path = new ResourceLocation(name.m_135827_(), TagManager.m_203918_((ResourceKey)registry.m_123023_()) + "/" + name.m_135815_() + ".json");
        List resources = Collections.emptyList();
        if (manager.m_7165_(path)) {
            try {
                resources = manager.m_7396_(path);
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't read {} tag list {} from {}", (Object)regName, (Object)name, (Object)path, (Object)ex);
                throw ERROR_READING_TAG.create((Object)regName, (Object)name);
            }
        } else if (registry.m_203431_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)name)).isEmpty()) {
            throw ViewTagCommand.TAG_NOT_FOUND.create((Object)regName, (Object)name);
        }
        Tag.Builder builder = Tag.Builder.m_13304_();
        int tagsProcessed = 0;
        for (Resource resource : resources) {
            try {
                InputStream inputstream = resource.m_6679_();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (json == null) {
                        Mantle.logger.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)regName, (Object)name, (Object)path, (Object)resource.m_7816_());
                        continue;
                    }
                    builder.m_13312_(json, resource.m_7816_());
                    ++tagsProcessed;
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException | RuntimeException ex) {
                Mantle.logger.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)regName, (Object)name, (Object)path, (Object)resource.m_7816_(), (Object)ex);
            }
            finally {
                IOUtils.closeQuietly((Closeable)resource);
            }
        }
        if (saveFile) {
            File output = new File(DumpAllTagsCommand.getOutputFile(context), path.m_135827_() + "/" + path.m_135815_());
            Path outputPath = output.toPath();
            try {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
                    writer.write(GSON.toJson((JsonElement)builder.m_13334_()));
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save {} tag {} to {}", (Object)regName, (Object)name, (Object)outputPath, (Object)ex);
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.mantle.dump_tag.success_log", new Object[]{regName, name, DumpAllTagsCommand.getOutputComponent(output)}), true);
        } else {
            TranslatableComponent message = new TranslatableComponent("command.mantle.dump_tag.success", new Object[]{regName, name});
            ((CommandSourceStack)context.getSource()).m_81354_((Component)message, true);
            Mantle.logger.info("Tag dump of {} tag '{}':\n{}", (Object)regName, (Object)name, (Object)GSON.toJson((JsonElement)builder.m_13334_()));
        }
        return tagsProcessed;
    }
}

