/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.RegistryArgument;

public class TagsForCommand {
    protected static final Dynamic2CommandExceptionType VALUE_NOT_FOUND = new Dynamic2CommandExceptionType((type, name) -> new TranslatableComponent("command.mantle.tags_for.not_found", new Object[]{type, name}));
    private static final Component NO_HELD_BLOCK = new TranslatableComponent("command.mantle.tags_for.no_held_block");
    private static final Component NO_HELD_ENTITY = new TranslatableComponent("command.mantle.tags_for.no_held_entity");
    private static final Component NO_HELD_POTION = new TranslatableComponent("command.mantle.tags_for.no_held_potion");
    private static final Component NO_HELD_FLUID = new TranslatableComponent("command.mantle.tags_for.no_held_fluid");
    private static final Component NO_HELD_ENCHANTMENT = new TranslatableComponent("command.mantle.tags_for.no_held_enchantment");
    private static final Component NO_TARGETED_ENTITY = new TranslatableComponent("command.mantle.tags_for.no_targeted_entity");
    private static final Component NO_TARGETED_BLOCK_ENTITY = new TranslatableComponent("command.mantle.tags_for.no_targeted_block_entity");
    private static final Component NO_TAGS = new TranslatableComponent("command.mantle.tags_for.no_tags");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(source -> MantleCommand.requiresDebugInfoOrOp(source, 2))).then(Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"type", RegistryArgument.registry()).suggests(MantleCommand.REGISTRY).then(Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleCommand.REGISTRY_VALUES).executes(TagsForCommand::runForId))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"held").then(Commands.m_82127_((String)"item").executes(TagsForCommand::heldItem))).then(Commands.m_82127_((String)"block").executes(TagsForCommand::heldBlock))).then(Commands.m_82127_((String)"enchantment").executes(TagsForCommand::heldEnchantments))).then(Commands.m_82127_((String)"fluid").executes(TagsForCommand::heldFluid))).then(Commands.m_82127_((String)"entity").executes(TagsForCommand::heldEntity))).then(Commands.m_82127_((String)"potion").executes(TagsForCommand::heldPotion)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"targeted").then(Commands.m_82127_((String)"block_entity").executes(TagsForCommand::targetedTileEntity))).then(Commands.m_82127_((String)"entity").executes(TagsForCommand::targetedEntity)));
    }

    private static <T> int printOwningTags(CommandContext<CommandSourceStack> context, Registry<T> registry, T value) {
        TranslatableComponent output = new TranslatableComponent("command.mantle.tags_for.success", new Object[]{registry.m_123023_().m_135782_(), registry.m_7981_(value)});
        List<ResourceLocation> tags = registry.m_203300_(registry.m_7447_(value)).stream().flatMap(Holder::getTagKeys).map(TagKey::f_203868_).toList();
        if (tags.isEmpty()) {
            output.m_130946_("\n* ").m_7220_(NO_TAGS);
        } else {
            tags.stream().sorted(ResourceLocation::compareNamespaced).forEach(arg_0 -> TagsForCommand.lambda$printOwningTags$2((MutableComponent)output, arg_0));
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)output, true);
        return tags.size();
    }

    private static <T> int runForResult(CommandContext<CommandSourceStack> context, Registry<T> registry) throws CommandSyntaxException {
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        Object value = registry.m_7745_(name);
        if (value == null) {
            throw VALUE_NOT_FOUND.create((Object)registry.m_123023_().m_135782_(), (Object)name);
        }
        return TagsForCommand.printOwningTags(context, registry, value);
    }

    private static int runForId(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Registry<?> result = RegistryArgument.getResult(context, "type");
        return TagsForCommand.runForResult(context, result);
    }

    private static int heldItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Item item = ((CommandSourceStack)context.getSource()).m_81375_().m_21205_().m_41720_();
        return TagsForCommand.printOwningTags(context, Registry.f_122827_, item);
    }

    private static int heldBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Item item = source.m_81375_().m_21205_().m_41720_();
        Block block = Block.m_49814_((Item)item);
        if (block != Blocks.f_50016_) {
            return TagsForCommand.printOwningTags(context, Registry.f_122824_, block);
        }
        source.m_81354_(NO_HELD_BLOCK, true);
        return 0;
    }

    private static int heldFluid(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        FluidStack fluidStack;
        IFluidHandler handler;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ItemStack stack = source.m_81375_().m_21205_();
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (capability.isPresent() && (handler = (IFluidHandler)capability.map(h -> h).orElse(EmptyFluidHandler.INSTANCE)).getTanks() > 0 && !(fluidStack = handler.getFluidInTank(0)).isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            return TagsForCommand.printOwningTags(context, Registry.f_122822_, fluid);
        }
        source.m_81354_(NO_HELD_FLUID, true);
        return 0;
    }

    private static int heldPotion(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ItemStack stack = source.m_81375_().m_21205_();
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (potion != Potions.f_43598_) {
            return TagsForCommand.printOwningTags(context, Registry.f_122828_, potion);
        }
        source.m_81354_(NO_HELD_POTION, true);
        return 0;
    }

    private static int heldEnchantments(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ItemStack stack = source.m_81375_().m_21205_();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (!enchantments.isEmpty()) {
            int totalTags = 0;
            for (Enchantment enchantment : enchantments.keySet()) {
                totalTags += TagsForCommand.printOwningTags(context, Registry.f_122825_, enchantment);
            }
            return totalTags;
        }
        source.m_81354_(NO_HELD_ENCHANTMENT, true);
        return 0;
    }

    private static int heldEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ItemStack stack = source.m_81375_().m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem egg = (SpawnEggItem)item;
            EntityType type = egg.m_43228_(stack.m_41783_());
            return TagsForCommand.printOwningTags(context, Registry.f_122826_, type);
        }
        source.m_81354_(NO_HELD_ENTITY, true);
        return 0;
    }

    private static int targetedTileEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockEntity be;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        ServerLevel level = source.m_81372_();
        BlockHitResult blockTrace = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockTrace.m_6662_() == HitResult.Type.BLOCK && (be = level.m_7702_(blockTrace.m_82425_())) != null) {
            BlockEntityType type = be.m_58903_();
            return TagsForCommand.printOwningTags(context, Registry.f_122830_, type);
        }
        source.m_81354_(NO_TARGETED_BLOCK_ENTITY, true);
        return 0;
    }

    private static int targetedEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        Vec3 start = player.m_20299_(1.0f);
        Vec3 look = player.m_20154_();
        double range = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())).m_22135_();
        Vec3 direction = start.m_82520_(look.f_82479_ * range, look.f_82480_ * range, look.f_82481_ * range);
        AABB bb = player.m_142469_().m_82363_(look.f_82479_ * range, look.f_82480_ * range, look.f_82481_ * range).m_82363_(1.0, 1.0, 1.0);
        EntityHitResult entityTrace = ProjectileUtil.m_37304_((Level)source.m_81372_(), (Entity)player, (Vec3)start, (Vec3)direction, (AABB)bb, e -> true);
        if (entityTrace != null) {
            EntityType target = entityTrace.m_82443_().m_6095_();
            return TagsForCommand.printOwningTags(context, Registry.f_122826_, target);
        }
        source.m_81354_(NO_TARGETED_ENTITY, true);
        return 0;
    }

    private static /* synthetic */ void lambda$printOwningTags$2(MutableComponent output, ResourceLocation tag) {
        output.m_130946_("\n* " + tag);
    }
}

