/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.iface.ICustomBow;
import com.blakebr0.cucumber.iface.IEnableable;
import java.util.function.Function;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BaseCrossbowItem
extends CrossbowItem
implements ICustomBow {
    public BaseCrossbowItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.apply(new Item.Properties()));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        BaseCrossbowItem baseCrossbowItem = this;
        if (baseCrossbowItem instanceof IEnableable) {
            IEnableable enableable = (IEnableable)((Object)baseCrossbowItem);
            if (enableable.isEnabled()) {
                super.m_6787_(group, items);
            }
        } else {
            super.m_6787_(group, items);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        int i = (int)((float)(this.m_8105_(stack) - timeLeft) * this.getDrawSpeedMulti(stack));
        float f = BaseCrossbowItem.getPowerForTime(i, stack);
        if (f >= 1.0f && !BaseCrossbowItem.m_40932_((ItemStack)stack) && BaseCrossbowItem.tryLoadProjectiles(entity, stack)) {
            BaseCrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource soundsource = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11841_, soundsource, 1.0f, 1.0f / (level.m_5822_().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    @Override
    public boolean hasFOVChange() {
        return false;
    }

    private static float getPowerForTime(int power, ItemStack stack) {
        float f = (float)power / (float)BaseCrossbowItem.m_40939_((ItemStack)stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private static boolean tryLoadProjectiles(LivingEntity entity, ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
        int j = i == 0 ? 1 : 3;
        boolean flag = entity instanceof Player && ((Player)entity).m_150110_().f_35937_;
        ItemStack itemstack = entity.m_6298_(stack);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (BaseCrossbowItem.loadProjectile(entity, stack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity entity, ItemStack bow, ItemStack arrow, boolean p_40866_, boolean p_40867_) {
        ItemStack itemstack;
        boolean flag;
        if (arrow.m_41619_()) {
            return false;
        }
        boolean bl = flag = p_40867_ && arrow.m_41720_() instanceof ArrowItem;
        if (!(flag || p_40867_ || p_40866_)) {
            itemstack = arrow.m_41620_(1);
            if (arrow.m_41619_() && entity instanceof Player) {
                ((Player)entity).m_150109_().m_36057_(arrow);
            }
        } else {
            itemstack = arrow.m_41777_();
        }
        BaseCrossbowItem.addChargedProjectile(bow, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack p_40929_, ItemStack p_40930_) {
        CompoundTag compoundtag = p_40929_.m_41784_();
        ListTag listtag = compoundtag.m_128425_("ChargedProjectiles", 9) ? compoundtag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        p_40930_.m_41739_(compoundtag1);
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
    }

    public static ItemPropertyFunction getPullPropertyGetter() {
        return (stack, level, entity, _unused) -> {
            if (entity == null) {
                return 0.0f;
            }
            return BaseCrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) * ((ICustomBow)stack.m_41720_()).getDrawSpeedMulti(stack) / (float)BaseCrossbowItem.m_40939_((ItemStack)stack);
        };
    }

    public static ItemPropertyFunction getPullingPropertyGetter() {
        return (stack, level, entity, _unused) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f;
    }

    public static ItemPropertyFunction getChargedPropertyGetter() {
        return (stack, level, entity, _unused) -> entity != null && BaseCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f;
    }

    public static ItemPropertyFunction getFireworkPropertyGetter() {
        return (stack, level, entity, _unused) -> entity != null && BaseCrossbowItem.m_40932_((ItemStack)stack) && BaseCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f;
    }
}

