/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.config.world;

import cofh.core.config.IBaseConfig;
import cofh.lib.util.Constants;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class MobConfig
implements IBaseConfig {
    public static final MobConfig EMPTY_CONFIG = new MobConfig("invalid", 0, 0, 0, List.of(), Constants.FALSE);
    protected String name;
    protected int chance;
    protected int min;
    protected int max;
    protected List<String> biomes;
    protected BiomeDictionary.Type restriction;
    protected Supplier<Boolean> enable;
    protected Supplier<Integer> configChance;
    protected Supplier<Integer> configMin;
    protected Supplier<Integer> configMax;
    protected ForgeConfigSpec.ConfigValue<String> configBiomes;
    private List<BiomeDictionary.Type> cachedBiomes = null;

    public MobConfig(String name, int chance, int min, int max, List<String> biomes, Supplier<Boolean> enable) {
        this(name, chance, min, max, biomes, BiomeDictionary.Type.OVERWORLD);
    }

    public MobCategory getClassification() {
        return MobCategory.CREATURE;
    }

    public MobConfig(String name, int chance, int min, int max, List<String> biomes, BiomeDictionary.Type restriction) {
        this.name = name;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.biomes = biomes;
        this.restriction = restriction;
    }

    public BiomeDictionary.Type getRestriction() {
        return this.restriction;
    }

    public int getChance() {
        return this.configChance.get();
    }

    public int getMin() {
        return this.configMin.get();
    }

    public int getMax() {
        return this.configMax.get();
    }

    public List<BiomeDictionary.Type> getBiomes() {
        if (this.cachedBiomes == null) {
            this.cachedBiomes = Stream.of(((String)this.configBiomes.get()).split(",")).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
        }
        return this.cachedBiomes;
    }

    public boolean shouldRegister() {
        return this.getChance() > 0;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " spawn config.").push(this.name + "_spawn");
        this.configChance = builder.comment("Chance to spawn (set to 0 to disable).").defineInRange("spawnChance", this.chance, 0, 256);
        this.configMin = builder.comment("Min to spawn in a group.").defineInRange("min", this.min, 0, 256);
        this.configMax = builder.comment("Max to spawn in a group.").defineInRange("max", this.max, 0, 256);
        StringBuilder sb = new StringBuilder();
        this.biomes.forEach(biome -> {
            sb.append((String)biome);
            sb.append(",");
        });
        this.configBiomes = builder.comment("List of biome types to spawn.").define("biomes", (Object)sb.toString());
        builder.pop();
    }

    @Override
    public void refresh() {
        this.cachedBiomes = null;
    }
}

