/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.IResourceStorage;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.util.Constants;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemStorageCoFH
implements IItemHandler,
IItemStackHolder,
IResourceStorage {
    protected static Predicate<ItemStack> DEFAULT_VALIDATOR = e -> true;
    protected final int baseCapacity;
    protected Supplier<Boolean> creative = Constants.FALSE;
    protected Supplier<Boolean> enabled = Constants.TRUE;
    protected Supplier<ItemStack> emptyItem = Constants.EMPTY_ITEM;
    protected Predicate<ItemStack> validator;
    @Nonnull
    protected ItemStack item = ItemStack.f_41583_;
    protected int capacity;

    public ItemStorageCoFH() {
        this(DEFAULT_VALIDATOR);
    }

    public ItemStorageCoFH(int capacity) {
        this(capacity, DEFAULT_VALIDATOR);
    }

    public ItemStorageCoFH(Predicate<ItemStack> validator) {
        this(0, validator);
    }

    public ItemStorageCoFH(int capacity, Predicate<ItemStack> validator) {
        this.baseCapacity = capacity;
        this.capacity = capacity;
        this.validator = validator;
    }

    public ItemStorageCoFH applyModifiers(float storageMod) {
        if (this.baseCapacity > 0) {
            this.setCapacity(Math.round((float)this.baseCapacity * storageMod));
        }
        return this;
    }

    public ItemStorageCoFH setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public ItemStorageCoFH setEmptyItem(Supplier<ItemStack> emptyItemSupplier) {
        if (emptyItemSupplier != null && emptyItemSupplier.get() != null) {
            this.emptyItem = emptyItemSupplier;
        }
        if (this.item.m_41619_()) {
            this.setItemStack(this.emptyItem.get());
        }
        return this;
    }

    public ItemStorageCoFH setCreative(Supplier<Boolean> creative) {
        this.creative = creative;
        if (!this.item.m_41619_() && this.isCreative()) {
            this.item.m_41764_(this.getCapacity());
        }
        return this;
    }

    public ItemStorageCoFH setEnabled(Supplier<Boolean> enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        }
        return this;
    }

    public ItemStorageCoFH setValidator(Predicate<ItemStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isItemValid(@Nonnull ItemStack stack) {
        return this.enabled.get() != false && this.validator.test(stack);
    }

    public void consume(int amount) {
        this.item = ItemHelper.consumeItem(this.item, amount);
    }

    public void setItemStack(ItemStack item) {
        this.item = item.m_41619_() ? this.emptyItem.get() : item;
    }

    public ItemStorageCoFH read(CompoundTag nbt) {
        this.item = this.loadItemStack(nbt);
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        this.saveItemStack(this.item, nbt);
        return nbt;
    }

    protected final ItemStack loadItemStack(CompoundTag nbt) {
        ItemStack retStack = ItemStack.m_41712_((CompoundTag)nbt);
        if (nbt.m_128441_("IntCount")) {
            int storedCount = nbt.m_128451_("IntCount");
            if (retStack.m_41613_() < storedCount) {
                retStack.m_41764_(storedCount);
            }
        }
        return retStack;
    }

    protected final void saveItemStack(ItemStack stack, CompoundTag nbt) {
        stack.m_41739_(nbt);
        if (stack.m_41613_() > 127) {
            nbt.m_128405_("IntCount", stack.m_41613_());
        }
    }

    @Override
    public ItemStack getItemStack() {
        return this.item;
    }

    @Override
    public int getCount() {
        return this.item.m_41613_();
    }

    @Override
    public boolean isEmpty() {
        return this.item.m_41619_();
    }

    @Override
    public boolean isFull() {
        return this.item.m_41613_() >= this.getCapacity();
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.item;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(stack) || !this.enabled.get().booleanValue()) {
            return stack;
        }
        if (this.item.m_41619_()) {
            int maxStack = this.capacity <= 0 ? stack.m_41741_() : this.capacity;
            int count = Math.min(stack.m_41613_(), maxStack);
            if (!simulate) {
                this.setItemStack(ItemHelper.cloneStack(stack, count));
            }
            return count >= stack.m_41613_() ? ItemStack.f_41583_ : ItemHelper.cloneStack(stack, stack.m_41613_() - count);
        }
        if (ItemHelper.itemsEqualWithTags(this.item, stack)) {
            int limit;
            int totalCount = this.item.m_41613_() + stack.m_41613_();
            if (totalCount <= (limit = this.getSlotLimit(0))) {
                if (!simulate) {
                    this.item.m_41764_(totalCount);
                }
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                this.item.m_41764_(limit);
            }
            return ItemHelper.cloneStack(stack, totalCount - limit);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0 || this.item.m_41619_() || !this.enabled.get().booleanValue()) {
            return ItemStack.f_41583_;
        }
        int retCount = Math.min(this.item.m_41613_(), amount);
        ItemStack ret = ItemHelper.cloneStack(this.item, retCount);
        if (!simulate && !this.isCreative()) {
            this.item.m_41774_(retCount);
            if (this.item.m_41619_()) {
                this.setItemStack(this.emptyItem.get());
            }
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        return this.capacity <= 0 ? this.item.m_41741_() : this.capacity;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.isItemValid(stack);
    }

    @Override
    public boolean clear() {
        if (this.isEmpty()) {
            return false;
        }
        this.item = this.emptyItem.get();
        return true;
    }

    @Override
    public void modify(int quantity) {
        if (this.isCreative()) {
            quantity = Math.max(quantity, 0);
        }
        this.item.m_41764_(Math.min(this.item.m_41613_() + quantity, this.getCapacity()));
        if (this.item.m_41619_()) {
            this.item = this.emptyItem.get();
        }
    }

    @Override
    public boolean isCreative() {
        return this.creative.get();
    }

    @Override
    public int getCapacity() {
        return this.getSlotLimit(0);
    }

    @Override
    public int getStored() {
        return this.item.m_41613_();
    }

    @Override
    public String getUnit() {
        return "";
    }
}

