/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.Constants;
import java.util.Collection;
import java.util.EnumMap;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockHelper {
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};
    public static final byte[] SIDE_ABOVE = new byte[]{3, 2, 1, 1, 1, 1};
    public static final byte[] SIDE_BELOW = new byte[]{2, 3, 0, 0, 0, 0};
    private static final EnumMap<Direction, Direction> SIDE_LEFT_LOOKUP = BlockHelper.computeMap(SIDE_LEFT);
    private static final EnumMap<Direction, Direction> SIDE_RIGHT_LOOKUP = BlockHelper.computeMap(SIDE_RIGHT);
    private static final EnumMap<Direction, Direction> SIDE_OPPOSITE_LOOKUP = BlockHelper.computeMap(SIDE_OPPOSITE);
    private static final EnumMap<Direction, Direction> SIDE_ABOVE_LOOKUP = BlockHelper.computeMap(SIDE_ABOVE);
    private static final EnumMap<Direction, Direction> SIDE_BELOW_LOOKUP = BlockHelper.computeMap(SIDE_BELOW);
    public static final byte[] ROTATE_CLOCK_Y = new byte[]{0, 1, 4, 5, 3, 2};
    public static final byte[] ROTATE_CLOCK_Z = new byte[]{5, 4, 2, 3, 0, 1};
    public static final byte[] ROTATE_CLOCK_X = new byte[]{2, 3, 1, 0, 4, 5};
    public static final byte[] ROTATE_COUNTER_Y = new byte[]{0, 1, 5, 4, 2, 3};
    public static final byte[] ROTATE_COUNTER_Z = new byte[]{4, 5, 2, 3, 1, 0};
    public static final byte[] ROTATE_COUNTER_X = new byte[]{3, 2, 0, 1, 4, 5};
    public static final byte[] INVERT_AROUND_Y = new byte[]{0, 1, 3, 2, 5, 4};
    public static final byte[] INVERT_AROUND_Z = new byte[]{1, 0, 2, 3, 5, 4};
    public static final byte[] INVERT_AROUND_X = new byte[]{1, 0, 3, 2, 4, 5};

    private BlockHelper() {
    }

    public static ToIntFunction<BlockState> lightValue(BooleanProperty property, int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)property) != false ? lightValue : 0;
    }

    public static ToIntFunction<BlockState> lightValue(int lightValue) {
        return state -> lightValue;
    }

    public static BlockEntity getAdjacentTileEntity(Level world, BlockPos pos, Direction dir) {
        pos = pos.m_142300_(dir);
        return world == null || !world.m_46805_(pos) ? null : world.m_7702_(pos);
    }

    public static BlockEntity getAdjacentTileEntity(Level world, BlockPos pos, int side) {
        return world == null ? null : BlockHelper.getAdjacentTileEntity(world, pos, Constants.DIRECTIONS[side]);
    }

    public static BlockEntity getAdjacentTileEntity(BlockEntity refTile, Direction dir) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.m_58904_(), refTile.m_58899_(), dir);
    }

    public static boolean attemptRotateBlock(BlockState state, Level world, BlockPos pos) {
        BlockState rotState;
        Collection properties = state.m_61147_();
        if (properties.contains(BlockStateProperties.f_61394_) || properties.contains(BlockStateProperties.f_61391_) || properties.contains(BlockStateProperties.f_61433_)) {
            return false;
        }
        if (properties.contains(BlockStateProperties.f_61392_) && state.m_61143_((Property)BlockStateProperties.f_61392_) != ChestType.SINGLE) {
            return false;
        }
        if (properties.contains(BlockStateProperties.f_61432_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61432_)).booleanValue()) {
            return false;
        }
        if (properties.contains(BlockStateProperties.f_61372_)) {
            int index = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122411_();
            for (int i = 1; i < 6; ++i) {
                BlockState rotState2 = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.m_122376_((int)(index + i)));
                if (rotState2 == state || !rotState2.m_60710_((LevelReader)world, pos)) continue;
                world.m_46597_(pos, rotState2);
                if (rotState2.m_60803_()) {
                    Block block = rotState2.m_60734_();
                    world.m_46672_(pos, block);
                    if (rotState2.m_60775_((BlockGetter)world, pos, (Direction)rotState2.m_61143_((Property)BlockStateProperties.f_61372_)) > 0) {
                        world.m_46672_(pos.m_142300_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_()), block);
                        world.m_46672_(pos.m_142300_(((Direction)rotState2.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_()), block);
                    }
                }
                return true;
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.f_61374_)) {
            int index = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_();
            for (int i = 1; i < 4; ++i) {
                BlockState rotState3 = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.m_122407_((int)(index + i)));
                if (rotState3 == state || !rotState3.m_60710_((LevelReader)world, pos)) continue;
                world.m_46597_(pos, rotState3);
                if (rotState3.m_60803_()) {
                    Block block = rotState3.m_60734_();
                    world.m_46672_(pos, block);
                    if (rotState3.m_60775_((BlockGetter)world, pos, (Direction)rotState3.m_61143_((Property)BlockStateProperties.f_61374_)) > 0) {
                        world.m_46672_(pos.m_142300_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_()), block);
                        world.m_46672_(pos.m_142300_(((Direction)rotState3.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_()), block);
                    }
                }
                return true;
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.f_61365_)) {
            BlockState rotState4 = switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)) {
                case Direction.Axis.Y -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
                case Direction.Axis.X -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
                default -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y);
            };
            if (rotState4 != state && rotState4.m_60710_((LevelReader)world, pos)) {
                world.m_46597_(pos, rotState4);
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.f_61373_)) {
            BlockState rotState5 = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)Rotation.CLOCKWISE_90.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)));
            if (rotState5 != state && rotState5.m_60710_((LevelReader)world, pos)) {
                world.m_46597_(pos, rotState5);
            }
            return true;
        }
        if (properties.contains(BlockStateProperties.f_61390_) && (rotState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(((Integer)state.m_61143_((Property)BlockStateProperties.f_61390_) + 1) % 16))) != state && rotState.m_60710_((LevelReader)world, pos)) {
            world.m_46597_(pos, rotState);
            return true;
        }
        if (state.m_60734_() instanceof BaseRailBlock && (rotState = state.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90)) != state && rotState.m_60710_((LevelReader)world, pos)) {
            world.m_46597_(pos, rotState);
            return true;
        }
        return false;
    }

    public static Direction left(Direction face) {
        return SIDE_LEFT_LOOKUP.get(face);
    }

    public static Direction right(Direction face) {
        return SIDE_RIGHT_LOOKUP.get(face);
    }

    public static Direction opposite(Direction face) {
        return SIDE_OPPOSITE_LOOKUP.get(face);
    }

    public static Direction above(Direction face) {
        return SIDE_ABOVE_LOOKUP.get(face);
    }

    public static Direction below(Direction face) {
        return SIDE_BELOW_LOOKUP.get(face);
    }

    public static boolean isAxial(BlockPos pos) {
        return pos.m_123341_() == 0 ? pos.m_123342_() == 0 || pos.m_123343_() == 0 : pos.m_123342_() == 0 && pos.m_123343_() == 0;
    }

    @Nullable
    public static Direction getSide(BlockPos pos) {
        if (!BlockHelper.isAxial(pos)) {
            return null;
        }
        if (pos.m_123342_() < 0) {
            return Direction.DOWN;
        }
        if (pos.m_123342_() > 0) {
            return Direction.UP;
        }
        if (pos.m_123343_() < 0) {
            return Direction.NORTH;
        }
        if (pos.m_123343_() > 0) {
            return Direction.SOUTH;
        }
        if (pos.m_123341_() < 0) {
            return Direction.WEST;
        }
        if (pos.m_123341_() > 0) {
            return Direction.EAST;
        }
        return null;
    }

    private static EnumMap<Direction, Direction> computeMap(byte[] arr) {
        EnumMap<Direction, Direction> map = new EnumMap<Direction, Direction>(Direction.class);
        for (int i = 0; i < 6; ++i) {
            map.put(Constants.DIRECTIONS[i], Constants.DIRECTIONS[arr[i]]);
        }
        return map;
    }
}

