/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.CollectFastenersEvent;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.util.Curve;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ClientEventHandler {
    private static final float HIGHLIGHT_ALPHA = 0.4f;

    @Nullable
    public static Connection getHitConnection() {
        Entity entity;
        net.minecraft.world.phys.HitResult result = Minecraft.m_91087_().f_91077_;
        if (result instanceof EntityHitResult && (entity = ((EntityHitResult)result).m_82443_()) instanceof HitConnection) {
            return ((HitConnection)entity).result.connection;
        }
        return null;
    }

    @SubscribeEvent
    public void gatherOverlayText(RenderGameOverlayEvent.Text event) {
        Connection conn = ClientEventHandler.getHitConnection();
        if (!(conn instanceof HangingLightsConnection)) {
            return;
        }
        Jingle jingle = ((HangingLightsConnection)conn).getPlayingJingle();
        if (jingle != null) {
            ArrayList lines = event.getRight();
            if (lines.size() > 0) {
                lines.add("");
            }
            lines.add("Song: " + jingle.getTitle());
            lines.add("Artist: " + jingle.getArtist());
        }
    }

    public static void updateHitConnection() {
        HitResult result;
        Minecraft mc = Minecraft.m_91087_();
        Entity viewer = mc.m_91288_();
        if (mc.f_91077_ != null && mc.f_91073_ != null && viewer != null && (result = ClientEventHandler.getHitConnection((Level)mc.f_91073_, viewer)) != null) {
            Vec3 eyes = viewer.m_20299_(1.0f);
            if (result.intersection.getResult().m_82554_(eyes) < mc.f_91077_.m_82450_().m_82554_(eyes)) {
                mc.f_91077_ = new EntityHitResult((Entity)new HitConnection((Level)mc.f_91073_, result));
                mc.f_91076_ = null;
            }
        }
    }

    @Nullable
    private static HitResult getHitConnection(Level world, Entity viewer) {
        AABB bounds = new AABB(viewer.m_142538_()).m_82400_(33.0);
        Set<Fastener<?>> fasteners = ClientEventHandler.collectFasteners(world, bounds);
        return ClientEventHandler.getHitConnection(viewer, bounds, fasteners);
    }

    private static Set<Fastener<?>> collectFasteners(Level world, AABB bounds) {
        LinkedHashSet fasteners = Sets.newLinkedHashSet();
        CollectFastenersEvent event = new CollectFastenersEvent(world, bounds, fasteners);
        world.m_45976_(FenceFastenerEntity.class, bounds).forEach(event::accept);
        int minX = Mth.m_14107_((double)(bounds.f_82288_ / 16.0));
        int maxX = Mth.m_14165_((double)(bounds.f_82291_ / 16.0));
        int minZ = Mth.m_14107_((double)(bounds.f_82290_ / 16.0));
        int maxZ = Mth.m_14165_((double)(bounds.f_82293_ / 16.0));
        ChunkSource provider = world.m_7726_();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                LevelChunk chunk = provider.m_62227_(x, z, false);
                if (chunk == null) continue;
                event.accept(chunk);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return fasteners;
    }

    @Nullable
    private static HitResult getHitConnection(Entity viewer, AABB bounds, Set<Fastener<?>> fasteners) {
        if (fasteners.isEmpty()) {
            return null;
        }
        Vec3 origin = viewer.m_20299_(1.0f);
        Vec3 look = viewer.m_20154_();
        double reach = Minecraft.m_91087_().f_91072_.m_105286_();
        Vec3 end = origin.m_82520_(look.f_82479_ * reach, look.f_82480_ * reach, look.f_82481_ * reach);
        Connection found = null;
        Intersection rayTrace = null;
        double distance = Double.MAX_VALUE;
        for (Fastener<?> fastener : fasteners) {
            for (Connection connection : fastener.getOwnConnections()) {
                double dist;
                Collidable collision;
                Intersection result;
                if (connection.getDestination().getType() == FastenerType.PLAYER || (result = (collision = connection.getCollision()).intersect(origin, end)) == null || !((dist = result.getResult().m_82554_(origin)) < distance)) continue;
                distance = dist;
                found = connection;
                rayTrace = result;
            }
        }
        if (found == null) {
            return null;
        }
        return new HitResult(found, rayTrace);
    }

    @SubscribeEvent
    public void drawBlockHighlight(DrawSelectionEvent.HighlightEntity event) {
        Entity entity = event.getTarget().m_82443_();
        Vec3 pos = event.getCamera().m_90583_();
        MultiBufferSource buf = event.getMultiBufferSource();
        if (entity instanceof FenceFastenerEntity) {
            this.drawFenceFastenerHighlight((FenceFastenerEntity)entity, event.getPoseStack(), buf.m_6299_(RenderType.m_110504_()), event.getPartialTicks(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        } else if (entity instanceof HitConnection) {
            HitConnection hit = (HitConnection)entity;
            if (hit.result.intersection.getFeatureType() == Connection.CORD_FEATURE) {
                PoseStack matrix = event.getPoseStack();
                matrix.m_85836_();
                Vec3 p = hit.result.connection.getFastener().getConnectionPoint();
                matrix.m_85837_(p.f_82479_ - pos.f_82479_, p.f_82480_ - pos.f_82480_, p.f_82481_ - pos.f_82481_);
                this.renderHighlight(hit.result.connection, matrix, buf.m_6299_(RenderType.m_110504_()));
                matrix.m_85849_();
            } else {
                AABB bb = hit.result.intersection.getHitBox().m_82386_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_).m_82400_(0.002);
                LevelRenderer.m_109646_((PoseStack)event.getPoseStack(), (VertexConsumer)buf.m_6299_(RenderType.m_110504_()), (AABB)bb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
        }
    }

    private void drawFenceFastenerHighlight(FenceFastenerEntity fence, PoseStack matrix, VertexConsumer buf, float delta, double dx, double dy, double dz) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (player.m_142582_((Entity)fence) || player.m_20280_((Entity)fence) <= 9.0)) {
            AABB selection = fence.m_142469_().m_82386_(-dx, -dy, -dz).m_82400_(0.002);
            LevelRenderer.m_109646_((PoseStack)matrix, (VertexConsumer)buf, (AABB)selection, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
    }

    private void renderHighlight(Connection connection, PoseStack matrix, VertexConsumer buf) {
        Curve cat = connection.getCatenary();
        if (cat == null) {
            return;
        }
        Vector3f p = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        LineBuilder builder = new LineBuilder(matrix, buf);
        float r = connection.getRadius() + 0.01f;
        for (int edge = 0; edge < 4; ++edge) {
            int n;
            p.m_122245_(cat.getX(0), cat.getY(0), cat.getZ(0));
            v1.m_122245_(cat.getDx(0), cat.getDy(0), cat.getDz(0));
            v1.m_122278_();
            v2.m_122245_(-v1.m_122239_(), -v1.m_122260_(), -v1.m_122269_());
            for (n = 0; edge == 0 && n < 8; ++n) {
                this.addVertex(builder, (n + 1) / 2 % 4, p, v1, v2, r);
            }
            this.addVertex(builder, edge, p, v1, v2, r);
            for (int i = 1; i < cat.getCount() - 1; ++i) {
                p.m_122245_(cat.getX(i), cat.getY(i), cat.getZ(i));
                v2.m_122245_(-cat.getDx(i), -cat.getDy(i), -cat.getDz(i));
                v2.m_122278_();
                this.addVertex(builder, edge, p, v1, v2, r);
                this.addVertex(builder, edge, p, v1, v2, r);
                v1.m_122245_(-v2.m_122239_(), -v2.m_122260_(), -v2.m_122269_());
            }
            p.m_122245_(cat.getX(), cat.getY(), cat.getZ());
            v2.m_122245_(-v1.m_122239_(), -v1.m_122260_(), -v1.m_122269_());
            this.addVertex(builder, edge, p, v1, v2, r);
            for (n = 0; edge == 0 && n < 8; ++n) {
                this.addVertex(builder, (n + 1) / 2 % 4, p, v1, v2, r);
            }
        }
    }

    private void addVertex(LineBuilder builder, int edge, Vector3f p, Vector3f v1, Vector3f v2, float r) {
        builder.accept(this.get(edge, p, v1, v2, r));
    }

    private Vector3f get(int edge, Vector3f p, Vector3f v1, Vector3f v2, float r) {
        Vector3f up = new Vector3f();
        Vector3f side = new Vector3f();
        if (v1.m_122276_(v2) < -0.99f) {
            float h = Mth.m_14116_((float)(v1.m_122239_() * v1.m_122239_() + v1.m_122269_() * v1.m_122269_()));
            if (h < 0.01f) {
                up.m_122245_(-1.0f, 0.0f, 0.0f);
            } else {
                up.m_122245_(-v1.m_122239_() / h * -v1.m_122260_(), -h, -v1.m_122269_() / h * -v1.m_122260_());
            }
        } else {
            up.m_122245_(v2.m_122239_(), v2.m_122260_(), v2.m_122269_());
            up.m_122255_(v1, 0.5f);
        }
        up.m_122278_();
        side.m_122245_(v1.m_122239_(), v1.m_122260_(), v1.m_122269_());
        side.m_122279_(up);
        side.m_122278_();
        side.m_122261_(edge == 0 || edge == 3 ? -r : r);
        up.m_122261_(edge < 2 ? -r : r);
        up.m_122253_(side);
        up.m_122253_(p);
        return up;
    }

    static class HitConnection
    extends Entity {
        final HitResult result;

        HitConnection(Level world, HitResult result) {
            super(EntityType.f_20461_, world);
            this.m_20234_(-1);
            this.result = result;
            this.m_146884_(result.intersection.getResult());
        }

        public boolean m_6469_(DamageSource source, float amount) {
            if (source.m_7639_() == Minecraft.m_91087_().f_91074_) {
                this.processAction(PlayerAction.ATTACK);
                return true;
            }
            return false;
        }

        public InteractionResult m_6096_(Player player, InteractionHand hand) {
            if (player == Minecraft.m_91087_().f_91074_) {
                this.processAction(PlayerAction.INTERACT);
                return InteractionResult.SUCCESS;
            }
            return super.m_6096_(player, hand);
        }

        private void processAction(PlayerAction action) {
            this.result.connection.processClientAction((Player)Minecraft.m_91087_().f_91074_, action, this.result.intersection);
        }

        public ItemStack getPickedResult(net.minecraft.world.phys.HitResult target) {
            return this.result.connection.getItemStack();
        }

        protected void m_8097_() {
        }

        protected void m_7380_(CompoundTag compound) {
        }

        protected void m_7378_(CompoundTag compound) {
        }

        public Packet<?> m_5654_() {
            return new Packet<PacketListener>(){

                public void m_5779_(FriendlyByteBuf buf) {
                }

                public void m_5797_(PacketListener listener) {
                }
            };
        }
    }

    private static final class HitResult {
        private final Connection connection;
        private final Intersection intersection;

        public HitResult(Connection connection, Intersection intersection) {
            this.connection = connection;
            this.intersection = intersection;
        }
    }

    static class LineBuilder {
        final PoseStack matrix;
        final VertexConsumer buf;
        Vector3f last;

        LineBuilder(PoseStack matrix, VertexConsumer buf) {
            this.matrix = matrix;
            this.buf = buf;
        }

        void accept(Vector3f pos) {
            if (this.last == null) {
                this.last = pos;
            } else {
                Vector3f n = pos.m_122281_();
                n.m_122267_(this.last);
                n.m_122278_();
                n.m_122249_(this.matrix.m_85850_().m_85864_());
                this.buf.m_85982_(this.matrix.m_85850_().m_85861_(), this.last.m_122239_(), this.last.m_122260_(), this.last.m_122269_()).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_5601_(n.m_122239_(), n.m_122260_(), n.m_122269_()).m_5752_();
                this.buf.m_85982_(this.matrix.m_85850_().m_85861_(), pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_5601_(n.m_122239_(), n.m_122260_(), n.m_122269_()).m_5752_();
                this.last = null;
            }
        }
    }
}

