/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener.accessor;

import javax.annotation.Nullable;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;

public final class BlockFastenerAccessor
implements FastenerAccessor {
    private BlockPos pos = BlockPos.f_121853_;

    public BlockFastenerAccessor() {
    }

    public BlockFastenerAccessor(BlockFastener fastener) {
        this(fastener.getPos());
    }

    public BlockFastenerAccessor(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public LazyOptional<Fastener<?>> get(Level world, boolean load) {
        BlockEntity entity;
        if ((load || world.m_46749_(this.pos)) && (entity = world.m_7702_(this.pos)) != null) {
            return entity.getCapability(CapabilityHandler.FASTENER_CAP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean isGone(Level world) {
        if (world.m_5776_() || !world.m_46749_(this.pos)) {
            return false;
        }
        BlockEntity entity = world.m_7702_(this.pos);
        return entity == null || !entity.getCapability(CapabilityHandler.FASTENER_CAP).isPresent();
    }

    @Override
    public FastenerType getType() {
        return FastenerType.BLOCK;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockFastenerAccessor) {
            return this.pos.equals((Object)((BlockFastenerAccessor)obj).pos);
        }
        return false;
    }

    @Override
    public CompoundTag serialize() {
        return NbtUtils.m_129224_((BlockPos)this.pos);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.pos = NbtUtils.m_129239_((CompoundTag)nbt);
    }
}

