/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.Optional;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public abstract class ConnectionItem
extends Item {
    private final RegistryObject<? extends ConnectionType<?>> type;

    public ConnectionItem(Item.Properties properties, RegistryObject<? extends ConnectionType<?>> type) {
        super(properties);
        this.type = type;
    }

    public final ConnectionType<?> getConnectionType() {
        return (ConnectionType)((Object)this.type.get());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        HangingEntity entity;
        Player user = context.m_43723_();
        if (user == null) {
            return super.m_6225_(context);
        }
        Level world = context.m_43725_();
        Direction side = context.m_43719_();
        BlockPos clickPos = context.m_8083_();
        Block fastener = (Block)FLBlocks.FASTENER.get();
        ItemStack stack = context.m_43722_();
        if (this.isConnectionInOtherHand(world, user, stack)) {
            return InteractionResult.PASS;
        }
        BlockState fastenerState = (BlockState)fastener.m_49966_().m_61124_((Property)FastenerBlock.f_52588_, (Comparable)side);
        BlockState currentBlockState = world.m_8055_(clickPos);
        BlockPlaceContext blockContext = new BlockPlaceContext(context);
        BlockPos placePos = blockContext.m_8083_();
        if (currentBlockState.m_60734_() == fastener) {
            if (!world.m_5776_()) {
                this.connect(stack, user, world, clickPos);
            }
            return InteractionResult.SUCCESS;
        }
        if (blockContext.m_7059_() && fastenerState.m_60710_((LevelReader)world, placePos)) {
            if (!world.m_5776_()) {
                this.connect(stack, user, world, placePos, fastenerState);
            }
            return InteractionResult.SUCCESS;
        }
        if (ConnectionItem.isFence(currentBlockState) && ((entity = FenceFastenerEntity.findHanging(world, clickPos)) == null || entity instanceof FenceFastenerEntity)) {
            if (!world.m_5776_()) {
                this.connectFence(stack, user, world, clickPos, (FenceFastenerEntity)entity);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean isConnectionInOtherHand(Level world, Player user, ItemStack stack) {
        Fastener attacher = (Fastener)user.getCapability(CapabilityHandler.FASTENER_CAP).orElseThrow(IllegalStateException::new);
        return attacher.getFirstConnection().filter(connection -> {
            CompoundTag nbt = connection.serializeLogic();
            return nbt.m_128456_() ? stack.m_41782_() : !NbtUtils.m_129235_((Tag)nbt, (Tag)stack.m_41783_(), (boolean)true);
        }).isPresent();
    }

    private void connect(ItemStack stack, Player user, Level world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity != null) {
            entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> this.connect(stack, user, world, (Fastener<?>)fastener));
        }
    }

    private void connect(ItemStack stack, Player user, Level world, BlockPos pos, BlockState state) {
        if (world.m_7731_(pos, state, 3)) {
            state.m_60734_().m_6402_(world, pos, state, (LivingEntity)user, stack);
            SoundType sound = state.m_60734_().getSoundType(state, (LevelReader)world, pos, (Entity)user);
            world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            BlockEntity entity = world.m_7702_(pos);
            if (entity != null) {
                entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(destination -> this.connect(stack, user, world, (Fastener<?>)destination, false));
            }
        }
    }

    public void connect(ItemStack stack, Player user, Level world, Fastener<?> fastener) {
        this.connect(stack, user, world, fastener, true);
    }

    public void connect(ItemStack stack, Player user, Level world, Fastener<?> fastener, boolean playConnectSound) {
        user.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(attacher -> {
            boolean playSound = playConnectSound;
            Optional<Connection> placing = attacher.getFirstConnection();
            if (placing.isPresent()) {
                Connection conn = placing.get();
                if (conn.reconnect(fastener)) {
                    conn.onConnect(world, user, stack);
                    stack.m_41774_(1);
                } else {
                    playSound = false;
                }
            } else {
                CompoundTag data = stack.m_41783_();
                fastener.connect(world, (Fastener<?>)attacher, this.getConnectionType(), data == null ? new CompoundTag() : data, false);
            }
            if (playSound) {
                Vec3 pos = fastener.getConnectionPoint();
                world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)FLSounds.CORD_CONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
    }

    private void connectFence(ItemStack stack, Player user, Level world, BlockPos pos, FenceFastenerEntity fastener) {
        boolean playConnectSound;
        if (fastener == null) {
            fastener = FenceFastenerEntity.create(world, pos);
            playConnectSound = false;
        } else {
            playConnectSound = true;
        }
        this.connect(stack, user, world, (Fastener)fastener.getCapability(CapabilityHandler.FASTENER_CAP).orElseThrow(IllegalStateException::new), playConnectSound);
    }

    public static boolean isFence(BlockState state) {
        return state.m_60767_().m_76333_() && state.m_204336_(BlockTags.f_13039_);
    }
}

