/*
 * Decompiled with CFR 0.152.
 */
package me.dinnerbeef.compressium;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.dinnerbeef.compressium.FallingDamageBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherrackBlock;
import net.minecraft.world.level.block.PoweredBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum CompressibleType {
    BLOCK("block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60999_().m_60918_(SoundType.f_56742_))),
    METAL("block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.5f).m_60999_().m_60918_(SoundType.f_56743_))),
    NETHER_METAL("block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.5f).m_60999_().m_60918_(SoundType.f_56725_))),
    DIRT("block", () -> new FallingDamageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60978_(1.5f).m_60918_(SoundType.f_56739_))),
    CLAY("block", () -> new FallingDamageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60978_(1.5f).m_60918_(SoundType.f_56739_))),
    COPPER("block", () -> new FallingDamageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.5f).m_60999_().m_60918_(SoundType.f_154663_))),
    SAND("falling", () -> new FallingDamageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76317_).m_60978_(1.5f).m_60918_(SoundType.f_56746_))),
    GRAVEL("falling", () -> new FallingDamageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76317_).m_60978_(1.5f).m_60918_(SoundType.f_56739_))),
    NETHER_RACK("nether_rack", () -> new NetherrackBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60999_().m_60918_(SoundType.f_56720_))),
    SOUL_SAND("soul_sand", () -> new SoulSandBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76317_).m_60978_(1.5f).m_60918_(SoundType.f_56716_))),
    POWERED("powered", () -> new PoweredBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60999_().m_60918_(SoundType.f_56743_)));

    private String blockType;
    private Supplier<? extends Block> constructor;
    private static final Logger LOGGER;
    public static final List<CompressibleType> VALUES;

    private CompressibleType(String block, Supplier<? extends Block> constructor) {
        this.blockType = block;
        this.constructor = constructor;
    }

    public String getBlockType() {
        return this.blockType;
    }

    public Supplier<? extends Block> getConstructor() {
        return this.constructor;
    }

    static Optional<CompressibleType> findFromName(String name) {
        return VALUES.stream().filter(e -> e.blockType.equals(name)).findFirst();
    }

    static {
        LOGGER = LogManager.getLogger();
        VALUES = Arrays.asList(CompressibleType.values());
    }

    public static class Serializer
    implements JsonDeserializer<CompressibleType>,
    JsonSerializer<CompressibleType> {
        public CompressibleType deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return CompressibleType.findFromName(element.getAsString()).orElseGet(() -> {
                LOGGER.warn("Failed to find the correct compressable type from {}", (Object)element.getAsString());
                return BLOCK;
            });
        }

        public JsonElement serialize(CompressibleType type, Type p_135856_, JsonSerializationContext p_135857_) {
            return new JsonPrimitive(type.getBlockType());
        }
    }
}

