/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.event.CharTypedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyPressedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetWithValue;
import com.davenonymous.libnonymous.helper.MathHelper;
import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;

public class WidgetInputField
extends WidgetWithValue<String> {
    private boolean hasShiftKeyDown;
    private int cursorPosition;
    private int lineScrollOffset;
    private int selectionEnd;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private int maxStringLength = 128;
    private String suggestion;
    private int cursorCounter;
    private Predicate<String> validator = Predicates.alwaysTrue();
    private final Font fontRenderer;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private BiFunction<String, Integer, String> textFormatter = (p_195610_0_, p_195610_1_) -> p_195610_0_;

    public WidgetInputField() {
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.lineScrollOffset = 0;
        this.value = "";
        this.addListener(KeyPressedEvent.class, (event, widget) -> {
            boolean result = this.onKeyPressed(event.keyCode, event.scanCode, event.modifiers);
            return !result ? WidgetEventResult.CONTINUE_PROCESSING : WidgetEventResult.HANDLED;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            boolean result = this.mouseClicked(event.x, event.y, event.button);
            return !result ? WidgetEventResult.CONTINUE_PROCESSING : WidgetEventResult.HANDLED;
        });
        this.addListener(CharTypedEvent.class, (event, widget) -> {
            boolean result = this.charTyped(event.chr, event.scanCode);
            return !result ? WidgetEventResult.CONTINUE_PROCESSING : WidgetEventResult.HANDLED;
        });
    }

    public WidgetInputField setValidator(Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public WidgetInputField setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        return this;
    }

    public boolean charTyped(char chr, int scanCode) {
        if (!this.isFocused()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)chr)) {
            if (this.enabled) {
                this.writeText(Character.toString(chr));
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(PoseStack pPoseStack, Screen screen) {
        super.draw(pPoseStack, screen);
        boolean renderX = false;
        boolean renderY = false;
    }

    private void drawSelectionBox(PoseStack pPoseStack, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
    }

    public WidgetInputField setSuggestion(String suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            if (textIn.length() > this.maxStringLength) {
                this.setValue(textIn.substring(0, this.maxStringLength));
            } else {
                this.setValue(textIn);
            }
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.lineScrollOffset = 0;
        }
    }

    public String getText() {
        return (String)this.value;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return ((String)this.value).substring(i, j);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(((String)this.value).length());
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.cursorPosition + num);
    }

    public void setCursorPosition(int pos) {
        this.setClampedCursorPosition(pos);
        if (!this.hasShiftKeyDown) {
            this.setSelectionPos(this.cursorPosition);
        }
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setClampedCursorPosition(int pos) {
        this.cursorPosition = MathHelper.clamp(pos, 0, ((String)this.value).length());
    }

    private boolean isFocused() {
        return this.isVisible() && this.enabled && this.focused;
    }

    private void delete(int p_212950_1_) {
        if (Screen.m_96637_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!((String)this.value).isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!((String)this.value).isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                Object s = "";
                if (i >= 0) {
                    s = ((String)this.value).substring(0, i);
                }
                if (j < ((String)this.value).length()) {
                    s = (String)s + ((String)this.value).substring(j);
                }
                if (this.validator.test((String)s)) {
                    this.setValue(s);
                    if (flag) {
                        this.moveCursorBy(num);
                    }
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursorPosition);
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = ((String)this.value).length();
                if ((i = ((String)this.value).indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && ((String)this.value).charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && ((String)this.value).charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && ((String)this.value).charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void writeText(String textToWrite) {
        int l;
        Object s = "";
        String s1 = SharedConstants.m_136190_((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - ((String)this.value).length() - (i - j);
        if (!((String)this.value).isEmpty()) {
            s = (String)s + ((String)this.value).substring(0, i);
        }
        if (k < s1.length()) {
            s = (String)s + s1.substring(0, k);
            l = k;
        } else {
            s = (String)s + s1;
            l = s1.length();
        }
        if (!((String)this.value).isEmpty() && j < ((String)this.value).length()) {
            s = (String)s + ((String)this.value).substring(j);
        }
        if (this.validator.test((String)s)) {
            this.setValue(s);
            this.setClampedCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
        }
    }

    private boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused()) {
            return false;
        }
        if (keyCode == 69) {
            return true;
        }
        this.hasShiftKeyDown = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.enabled) {
                this.writeText(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            if (this.enabled) {
                this.writeText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.enabled) {
                    this.hasShiftKeyDown = false;
                    this.delete(-1);
                    this.hasShiftKeyDown = Screen.m_96638_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.enabled) {
                    this.hasShiftKeyDown = false;
                    this.delete(1);
                    this.hasShiftKeyDown = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        int thisX = this.getActualX();
        int thisY = this.getActualY();
        if (!this.isFocused()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)thisX && mouseX < (double)(thisX + this.width) && mouseY >= (double)thisY && mouseY < (double)(thisY + this.height);
        if (this.canLoseFocus) {
            this.focused = flag;
        }
        if (this.isFocused() && flag && mouseButton == 0) {
            int i = (int)Math.floor(mouseX) - this.x;
            if (this.enableBackgroundDrawing) {
                i -= 4;
            }
            String s = this.fontRenderer.m_92834_(((String)this.value).substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.m_92834_(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public int getAdjustedWidth() {
        return this.enableBackgroundDrawing ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = ((String)this.value).length();
        this.selectionEnd = MathHelper.clamp(position, 0, i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.m_92834_(((String)this.value).substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.m_92837_((String)this.value, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.clamp(this.lineScrollOffset, 0, i);
        }
    }
}

