/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.helper;

import com.davenonymous.libnonymous.json.MCJsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStateSerializationHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static CompoundTag serializeBlockStateToNBT(BlockState state) {
        CompoundTag result = new CompoundTag();
        Block block = state.m_60734_();
        result.m_128359_("block", block.getRegistryName().toString());
        if (state.m_61147_().size() > 0) {
            CompoundTag propertiesTag = new CompoundTag();
            for (Property property : state.m_61147_()) {
                propertiesTag.m_128359_(property.m_61708_(), state.m_61143_(property).toString());
            }
            result.m_128365_("properties", (Tag)propertiesTag);
        }
        return result;
    }

    public static BlockState deserializeBlockState(CompoundTag nbt) {
        if (!nbt.m_128441_("block")) {
            LOGGER.warn("NBT compound {} is not a blockstate", (Object)nbt);
            return null;
        }
        ResourceLocation blockId = ResourceLocation.m_135820_((String)nbt.m_128461_("block"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
        if (block == null) {
            LOGGER.warn("Unknown block {} in NBT package", (Object)nbt.m_128461_("block"));
            return null;
        }
        BlockState state = block.m_49966_();
        if (nbt.m_128441_("properties")) {
            CompoundTag propertiesTag = nbt.m_128469_("properties");
            for (String propertyName : propertiesTag.m_128431_()) {
                Property blockProperty = block.m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals(propertyName)).findFirst().get();
                if (blockProperty == null) {
                    LOGGER.warn("The property '{}' is not valid for block {}", (Object)propertyName, (Object)blockId);
                    continue;
                }
                String valueString = propertiesTag.m_128461_(propertyName);
                Optional propValue = blockProperty.m_6215_(valueString);
                if (!propValue.isPresent()) {
                    LOGGER.warn("The property '{}' with value '{}' could not be parsed!", (Object)propertyName, (Object)valueString);
                    continue;
                }
                try {
                    state = (BlockState)state.m_61124_(blockProperty, (Comparable)propValue.get());
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to update state for block {}. The mod that adds this block has issues.", (Object)block.getRegistryName());
                }
            }
        }
        return state;
    }

    public static void serializeBlockState(FriendlyByteBuf buffer, BlockState state) {
        buffer.m_130085_(state.m_60734_().getRegistryName());
        Collection properties = state.m_61147_();
        buffer.writeInt(properties.size());
        for (Property property : properties) {
            buffer.m_130070_(property.m_61708_());
            buffer.m_130070_(state.m_61143_(property).toString());
        }
    }

    public static BlockState deserializeBlockState(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block != null) {
            int size = buffer.readInt();
            BlockState state = block.m_49966_();
            for (int i = 0; i < size; ++i) {
                Optional propValue;
                String propName = buffer.m_130277_();
                String value = buffer.m_130277_();
                Property blockProperty = block.m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals(propName)).findFirst().get();
                if (blockProperty == null || !(propValue = blockProperty.m_6215_(value)).isPresent()) continue;
                try {
                    state = (BlockState)state.m_61124_(blockProperty, (Comparable)propValue.get());
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to read state for block {}. The mod that adds this block has issues.", (Object)block.getRegistryName());
                }
            }
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static JsonObject serializeBlockState(BlockState state) {
        JsonObject result = new JsonObject();
        Block block = state.m_60734_();
        result.addProperty("block", block.getRegistryName().toString());
        if (state.m_61147_().size() > 0) {
            JsonObject propertiesObj = new JsonObject();
            for (Property property : state.m_61147_()) {
                propertiesObj.addProperty(property.m_61708_(), state.m_61143_(property).toString());
            }
            result.add("properties", (JsonElement)propertiesObj);
        }
        return result;
    }

    public static boolean isValidBlockState(JsonObject json) {
        String blockName = json.get("block").getAsString();
        if (blockName.equals("minecraft:air")) {
            return true;
        }
        Block block = MCJsonUtils.getBlock(json, "block");
        return block != null && !block.getRegistryName().toString().equals("minecraft:air");
    }

    public static BlockState deserializeBlockState(JsonObject json) {
        Block block = MCJsonUtils.getBlock(json, "block");
        BlockState state = block.m_49966_();
        if (json.has("properties")) {
            JsonElement propertiesElement = json.get("properties");
            if (propertiesElement.isJsonObject()) {
                JsonObject props = propertiesElement.getAsJsonObject();
                for (Map.Entry property : props.entrySet()) {
                    Property blockProperty = block.m_49966_().m_61147_().stream().filter(prop -> prop.m_61708_().equals(property.getKey())).findFirst().get();
                    if (blockProperty != null) {
                        if (((JsonElement)property.getValue()).isJsonPrimitive()) {
                            String valueString = ((JsonElement)property.getValue()).getAsString();
                            Optional propValue = blockProperty.m_6215_(valueString);
                            if (propValue.isPresent()) {
                                try {
                                    state = (BlockState)state.m_61124_(blockProperty, (Comparable)propValue.get());
                                }
                                catch (Exception e) {
                                    LOGGER.error("Failed to update state for block {}. The mod that adds this block has issues.", (Object)block.getRegistryName());
                                }
                                continue;
                            }
                            throw new JsonSyntaxException("The property " + (String)property.getKey() + " with value " + valueString + " could not be parsed!");
                        }
                        throw new JsonSyntaxException("Expected property value for " + (String)property.getKey() + " to be primitive string. Got " + property.getValue());
                    }
                    throw new JsonSyntaxException("The property " + (String)property.getKey() + " is not valid for block " + block.getRegistryName());
                }
            } else {
                throw new JsonSyntaxException("Expected properties to be an object. Got " + propertiesElement);
            }
        }
        return state;
    }
}

