/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.registration;

import com.davenonymous.libnonymous.Libnonymous;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public final class AnnotatedInstanceUtil {
    public static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<String> pluginClassNames = new LinkedHashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            for (ModFileScanData.AnnotationData a : scanData.getAnnotations()) {
                if (!Objects.equals(a.annotationType(), annotationType)) continue;
                if (a.annotationData().containsKey("mod")) {
                    String requiredMod = (String)a.annotationData().get("mod");
                    if (!ModList.get().isLoaded(requiredMod)) continue;
                }
                String memberName = a.memberName();
                pluginClassNames.add(memberName);
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String className : pluginClassNames) {
            try {
                Class<?> asmClass = Class.forName(className);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                instances.add(instance);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                Libnonymous.LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            }
        }
        return instances;
    }
}

