/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.render;

import com.davenonymous.libnonymous.render.MultiBlockBlockAndTintGetter;
import com.davenonymous.libnonymous.render.MultiBlockBlockColors;
import com.davenonymous.libnonymous.render.MultiblockBakedModel;
import com.davenonymous.libnonymous.render.TintedBakedQuad;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class MultiModelBlockRenderer {
    static final Direction[] DIRECTIONS = Direction.values();
    private final BlockColors blockColors;

    public static void renderMultiBlockModel(MultiblockBlockModel model, BlockAndTintGetter pRealWorld, VertexConsumer buffer, PoseStack pose, int pPackedLight) {
        MultiblockBakedModel baked = MultiblockBakedModel.of(model);
        MultiBlockBlockColors blockColors = new MultiBlockBlockColors(model);
        MultiBlockBlockAndTintGetter fakeLevel = new MultiBlockBlockAndTintGetter(model, pRealWorld);
        MultiModelBlockRenderer renderer = new MultiModelBlockRenderer(blockColors);
        renderer.tesselateWithoutAO(fakeLevel, (BakedModel)baked, Blocks.f_50493_.m_49966_(), BlockPos.f_121853_, pose, buffer, pPackedLight, new Random(), OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
    }

    public MultiModelBlockRenderer(BlockColors pBlockColors) {
        this.blockColors = pBlockColors;
    }

    public boolean tesselateWithoutAO(BlockAndTintGetter pLevel, BakedModel pModel, BlockState pState, BlockPos pPos, PoseStack pPoseStack, VertexConsumer pConsumer, int pPackedLight, Random pRandom, int pPackedOverlay, IModelData modelData) {
        BitSet bitset = new BitSet(3);
        List list1 = pModel.getQuads(pState, (Direction)null, pRandom, modelData);
        if (!list1.isEmpty()) {
            this.renderModelFaceFlat(pLevel, pState, pPos, pPackedLight, pPackedOverlay, false, pPoseStack, pConsumer, list1, bitset);
            return true;
        }
        return false;
    }

    private void putQuadData(BlockAndTintGetter pLevel, BlockState pState, BlockPos pPos, VertexConsumer pConsumer, PoseStack.Pose pPose, BakedQuad pQuad, float pBrightness0, float pBrightness1, float pBrightness2, float pBrightness3, int pLightmap0, int pLightmap1, int pLightmap2, int pLightmap3, int pPackedOverlay) {
        float f2;
        float f1;
        float f;
        if (pQuad.m_111304_()) {
            int i;
            if (pQuad instanceof TintedBakedQuad) {
                TintedBakedQuad tintedBakedQuad = (TintedBakedQuad)pQuad;
                i = this.blockColors.m_92577_(tintedBakedQuad.state, pLevel, tintedBakedQuad.pos, pQuad.m_111305_());
            } else {
                i = this.blockColors.m_92577_(pState, pLevel, pPos, pQuad.m_111305_());
            }
            f = (float)(i >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i & 0xFF) / 255.0f;
        } else {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        pConsumer.m_85995_(pPose, pQuad, new float[]{pBrightness0, pBrightness1, pBrightness2, pBrightness3}, f, f1, f2, new int[]{pLightmap0, pLightmap1, pLightmap2, pLightmap3}, pPackedOverlay, true);
    }

    private void calculateShape(BlockAndTintGetter pLevel, BlockState pState, BlockPos pPos, int[] pVertices, Direction pDirection, @Nullable float[] pShape, BitSet pShapeFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(pVertices[i * 8]);
            float f7 = Float.intBitsToFloat(pVertices[i * 8 + 1]);
            float f8 = Float.intBitsToFloat(pVertices[i * 8 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (pShape != null) {
            pShape[Direction.WEST.m_122411_()] = f;
            pShape[Direction.EAST.m_122411_()] = f3;
            pShape[Direction.DOWN.m_122411_()] = f1;
            pShape[Direction.UP.m_122411_()] = f4;
            pShape[Direction.NORTH.m_122411_()] = f2;
            pShape[Direction.SOUTH.m_122411_()] = f5;
            int j = DIRECTIONS.length;
            pShape[Direction.WEST.m_122411_() + j] = 1.0f - f;
            pShape[Direction.EAST.m_122411_() + j] = 1.0f - f3;
            pShape[Direction.DOWN.m_122411_() + j] = 1.0f - f1;
            pShape[Direction.UP.m_122411_() + j] = 1.0f - f4;
            pShape[Direction.NORTH.m_122411_() + j] = 1.0f - f2;
            pShape[Direction.SOUTH.m_122411_() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (pDirection) {
            case DOWN: {
                pShapeFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                pShapeFlags.set(0, f1 == f4 && (f1 < 1.0E-4f || pState.m_60838_((BlockGetter)pLevel, pPos)));
                break;
            }
            case UP: {
                pShapeFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                pShapeFlags.set(0, f1 == f4 && (f4 > 0.9999f || pState.m_60838_((BlockGetter)pLevel, pPos)));
                break;
            }
            case NORTH: {
                pShapeFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                pShapeFlags.set(0, f2 == f5 && (f2 < 1.0E-4f || pState.m_60838_((BlockGetter)pLevel, pPos)));
                break;
            }
            case SOUTH: {
                pShapeFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                pShapeFlags.set(0, f2 == f5 && (f5 > 0.9999f || pState.m_60838_((BlockGetter)pLevel, pPos)));
                break;
            }
            case WEST: {
                pShapeFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                pShapeFlags.set(0, f == f3 && (f < 1.0E-4f || pState.m_60838_((BlockGetter)pLevel, pPos)));
                break;
            }
            case EAST: {
                pShapeFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                pShapeFlags.set(0, f == f3 && (f3 > 0.9999f || pState.m_60838_((BlockGetter)pLevel, pPos)));
            }
        }
    }

    private void renderModelFaceFlat(BlockAndTintGetter pLevel, BlockState pState, BlockPos pPos, int pPackedLight, int pPackedOverlay, boolean pRepackLight, PoseStack pPoseStack, VertexConsumer pConsumer, List<BakedQuad> pQuads, BitSet pShapeFlags) {
        for (BakedQuad bakedquad : pQuads) {
            if (pRepackLight) {
                this.calculateShape(pLevel, pState, pPos, bakedquad.m_111303_(), bakedquad.m_111306_(), null, pShapeFlags);
                BlockPos blockpos = pShapeFlags.get(0) ? pPos.m_142300_(bakedquad.m_111306_()) : pPos;
                pPackedLight = LevelRenderer.m_109537_((BlockAndTintGetter)pLevel, (BlockState)pState, (BlockPos)blockpos);
            }
            float f = pLevel.m_7717_(bakedquad.m_111306_(), bakedquad.m_111307_());
            this.putQuadData(pLevel, pState, pPos, pConsumer, pPoseStack.m_85850_(), bakedquad, f, f, f, f, pPackedLight, pPackedLight, pPackedLight, pPackedLight, pPackedOverlay);
        }
    }
}

