/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization;

import com.davenonymous.libnonymous.helper.BlockStateSerializationHelper;
import com.davenonymous.libnonymous.serialization.packetbuffer.PacketBufferFieldHandlers;
import com.davenonymous.libnonymous.utils.FloodFill;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiblockBlockModel {
    public Map<BlockPos, BlockState> blocks;
    public Map<BlockState, List<BlockPos>> reverseBlocks;
    public Map<BlockState, Character> refMap;
    public char[][][] blocksAsArray;
    public char[][][] blocksAsArray90;
    public char[][][] blocksAsArray180;
    public char[][][] blocksAsArray270;
    public ResourceLocation id;
    private static final Logger LOGGER = LogManager.getLogger();
    public int width = 0;
    public int height = 0;
    public int depth = 0;

    public MultiblockBlockModel(ResourceLocation id) {
        this.id = id;
    }

    public MultiblockBlockModel(FriendlyByteBuf buffer) {
        this.id = buffer.m_130281_();
        int size = buffer.readInt();
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buffer.m_130135_();
            BlockState state = BlockStateSerializationHelper.deserializeBlockState(buffer);
            blocks.put(pos, state);
        }
        this.setBlocks(blocks);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.writeInt(this.blocks.size());
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            buffer.m_130064_(entry.getKey());
            BlockStateSerializationHelper.serializeBlockState(buffer, entry.getValue());
        }
    }

    public void removeBlockState(BlockState state) {
        HashMap<BlockPos, BlockState> newBlocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            if (entry.getValue().equals(state)) continue;
            newBlocks.put(entry.getKey(), entry.getValue());
        }
        this.setBlocks(newBlocks);
    }

    public void setBlocksShifted(Map<BlockPos, BlockState> blocks) {
        int lowestX = Integer.MAX_VALUE;
        int lowestY = Integer.MAX_VALUE;
        int lowestZ = Integer.MAX_VALUE;
        for (BlockPos pos : blocks.keySet()) {
            BlockState state = blocks.get(pos);
            if (state.m_60734_() == Blocks.f_50493_) continue;
            if (pos.m_123341_() < lowestX) {
                lowestX = pos.m_123341_();
            }
            if (pos.m_123342_() < lowestY) {
                lowestY = pos.m_123342_();
            }
            if (pos.m_123343_() >= lowestZ) continue;
            lowestZ = pos.m_123343_();
        }
        HashMap<BlockPos, BlockState> shifted = new HashMap<BlockPos, BlockState>();
        for (BlockPos pos : blocks.keySet()) {
            BlockState state;
            BlockPos newPos = pos.m_142082_(-lowestX, -lowestY, -lowestZ);
            if (shifted.containsKey(newPos) || (state = blocks.get(pos)).m_60734_() == Blocks.f_50493_) continue;
            shifted.put(newPos, state);
        }
        this.setBlocks(shifted);
    }

    public void setBlocks(Map<BlockPos, BlockState> blocks) {
        this.blocks = blocks;
        this.width = 0;
        this.height = 0;
        this.depth = 0;
        for (BlockPos pos : blocks.keySet()) {
            if (pos.m_123341_() > this.width) {
                this.width = pos.m_123341_();
            }
            if (pos.m_123342_() > this.height) {
                this.height = pos.m_123342_();
            }
            if (pos.m_123343_() <= this.depth) continue;
            this.depth = pos.m_123343_();
        }
        char refChar = 'a';
        this.refMap = new HashMap<BlockState, Character>();
        this.blocksAsArray = new char[this.width + 1][this.height + 1][this.depth + 1];
        for (BlockPos pos : blocks.keySet().stream().sorted().toList()) {
            BlockState state = blocks.get(pos);
            char c = refChar;
            refChar = (char)(refChar + 1);
            char stateChar = this.refMap.getOrDefault(state, Character.valueOf(c)).charValue();
            if (!this.refMap.containsKey(state)) {
                this.refMap.put(state, Character.valueOf(stateChar));
            }
            this.blocksAsArray[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()] = stateChar;
        }
        this.blocksAsArray90 = this.rotateMapCW(this.blocksAsArray);
        this.blocksAsArray180 = this.rotateMapCW(this.blocksAsArray90);
        this.blocksAsArray270 = this.rotateMapCW(this.blocksAsArray180);
        this.createReverseMap();
    }

    private void createReverseMap() {
        this.reverseBlocks = new HashMap<BlockState, List<BlockPos>>();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            if (!this.reverseBlocks.containsKey(entry.getValue())) {
                this.reverseBlocks.put(entry.getValue(), new ArrayList());
            }
            this.reverseBlocks.get(entry.getValue()).add(entry.getKey());
        }
    }

    private char[][][] rotateMapCW(char[][][] map) {
        char[][][] ret = new char[map.length][][];
        for (int y = 0; y < map.length; ++y) {
            int M = map[y].length;
            int N = map[y][0].length;
            char[][] slice = new char[N][M];
            for (int r = 0; r < M; ++r) {
                for (int c = 0; c < N; ++c) {
                    slice[c][M - 1 - r] = map[y][r][c];
                }
            }
            ret[y] = slice;
        }
        return ret;
    }

    public void setBlocksByFloodFill(LevelReader world, BlockPos pos) {
        FloodFill floodFill = new FloodFill(world, pos);
        Map<BlockPos, BlockState> connectedBlocks = floodFill.getConnectedBlocks();
        if (connectedBlocks.size() == 0) {
            return;
        }
        this.setBlocks(connectedBlocks);
    }

    public int getBlockCount() {
        return this.blocks.keySet().size();
    }

    public Set<BlockPos> getRelevantPositions() {
        return this.blocks.keySet();
    }

    public double getScaleRatio(boolean inclHeight) {
        int dim = Math.max(this.width, this.depth);
        if (inclHeight || this.height > 10) {
            dim = Math.max(this.height, dim);
        }
        if (this.height > 6 || ++dim <= 4) {
            dim = Math.max(6, dim);
        }
        return 1.0 / (double)dim;
    }

    public String serializePretty() {
        if (this.width + 1 == 0 || this.height + 1 == 0 || this.depth + 1 == 0) {
            LOGGER.warn("Can not serialize model for type: '{}', invalid dimensions: w={}, h={}, d={}", (Object)this.id, (Object)this.width, (Object)this.height, (Object)this.depth);
            return "";
        }
        char[][][] map = new char[this.width + 1][this.height + 1][this.depth + 1];
        StringBuilder refMapBuilder = new StringBuilder();
        refMapBuilder.append("  \"ref\": {\n");
        char nextRef = 'a';
        HashMap<String, Character> refMap = new HashMap<String, Character>();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            char thisRef;
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            JsonObject json = BlockStateSerializationHelper.serializeBlockState(state);
            String jsonString = json.toString();
            if (refMap.containsKey(jsonString)) {
                thisRef = ((Character)refMap.get(jsonString)).charValue();
            } else {
                char c = nextRef;
                nextRef = (char)(nextRef + 1);
                thisRef = c;
                refMap.put(jsonString, Character.valueOf(thisRef));
                refMapBuilder.append("    \"" + thisRef + "\": " + jsonString + ",\n");
            }
            map[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()] = thisRef;
        }
        refMapBuilder.deleteCharAt(refMapBuilder.length() - 2);
        refMapBuilder.append("  },\n");
        StringBuilder output = new StringBuilder("{\n");
        output.append("  \"type\": \"" + this.id.toString() + "\",\n");
        output.append("  \"version\": 3,\n");
        output.append((CharSequence)refMapBuilder);
        output.append("  \"shape\": [\n");
        for (int x = map.length - 1; x >= 0; --x) {
            output.append("    [\n");
            for (int y = map[x].length - 1; y >= 0; --y) {
                StringBuilder builder = new StringBuilder();
                for (int z = 0; z < map[x][y].length; ++z) {
                    char chr = ' ';
                    if (map[x][y][z] != '\u0000') {
                        chr = map[x][y][z];
                    }
                    builder.append(chr);
                }
                output.append("      \"" + builder + "\",\n");
            }
            output.deleteCharAt(output.length() - 2);
            output.append("    ],\n");
        }
        output.deleteCharAt(output.length() - 2);
        output.append("  ]\n}\n");
        return output.toString();
    }

    public boolean equalsWithRotation(MultiblockBlockModel tempModel) {
        if (tempModel == this) {
            return true;
        }
        if (tempModel == null) {
            return false;
        }
        if (this.blocks.size() != tempModel.blocks.size()) {
            return false;
        }
        boolean no0 = false;
        boolean no90 = false;
        boolean no180 = false;
        boolean no270 = false;
        for (int x = 0; x < this.width; ++x) {
            block1: for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    char shouldBe = this.blocksAsArray[x][y][z];
                    char at0 = tempModel.blocksAsArray[x][y][z];
                    char at90 = tempModel.blocksAsArray90[x][y][z];
                    char at180 = tempModel.blocksAsArray180[x][y][z];
                    char at270 = tempModel.blocksAsArray270[x][y][z];
                    if (at0 != shouldBe) {
                        no0 = true;
                    }
                    if (at90 != shouldBe) {
                        no90 = true;
                    }
                    if (at180 != shouldBe) {
                        no180 = true;
                    }
                    if (at270 != shouldBe) {
                        no270 = true;
                    }
                    if (no0 && no90 && no180 && no270) continue block1;
                }
            }
        }
        return no0 || no90 || no180 || no270;
    }

    static {
        PacketBufferFieldHandlers.addIOHandler(MultiblockBlockModel.class, MultiblockBlockModel::new, MultiblockBlockModel::writeToBuffer);
    }
}

