/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization.nbt;

import com.davenonymous.libnonymous.serialization.FieldUtils;
import com.davenonymous.libnonymous.serialization.Store;
import com.davenonymous.libnonymous.serialization.nbt.NBTFieldHandlers;
import com.davenonymous.libnonymous.serialization.nbt.NBTFieldSerializationData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTFieldUtils {
    private static Map<Class, List<NBTFieldSerializationData>> classNbtCache = new HashMap<Class, List<NBTFieldSerializationData>>();
    private static final Logger LOGGER = LogManager.getLogger();

    public static CompoundTag writeFieldsToNBT(List<NBTFieldSerializationData> NBTActions, Object source, CompoundTag targetCompound, Predicate<NBTFieldSerializationData> test) {
        for (NBTFieldSerializationData data : NBTActions) {
            if (!test.test(data)) continue;
            try {
                Object value = data.field.get(source);
                data.writer.write(data.key, value, targetCompound);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return targetCompound;
    }

    public static void readFieldsFromNBT(List<NBTFieldSerializationData> NBTActions, Object target, CompoundTag sourceCompound, Predicate<NBTFieldSerializationData> test) {
        for (NBTFieldSerializationData data : NBTActions) {
            if (!test.test(data)) continue;
            try {
                Object value = data.reader.read(data.key, sourceCompound, data.field.get(target));
                data.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<NBTFieldSerializationData> initSerializableStoreFields(Class clz) {
        if (classNbtCache.containsKey(clz)) {
            return classNbtCache.get(clz);
        }
        ArrayList<NBTFieldSerializationData> actionList = new ArrayList<NBTFieldSerializationData>();
        for (Field field : FieldUtils.getAllDeclaredFields(clz)) {
            Store annotation = field.getDeclaredAnnotation(Store.class);
            if (annotation == null) continue;
            if (!NBTFieldHandlers.hasNBTHandler(field.getType())) {
                LOGGER.warn("No NBT serialization methods for field='{}' (type='{}') in class='{}' exists.", (Object)field.getName(), (Object)field.getType().getSimpleName(), (Object)clz.getSimpleName());
                continue;
            }
            Store storeAnnotation = annotation;
            String key = storeAnnotation.key();
            if (key.equals("")) {
                key = field.getName();
            }
            actionList.add(new NBTFieldSerializationData(field, key, storeAnnotation.storeWithItem(), storeAnnotation.sendInUpdatePackage()));
            field.setAccessible(true);
        }
        classNbtCache.put(clz, actionList);
        return actionList;
    }
}

