/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization.packetbuffer;

import com.davenonymous.libnonymous.helper.BlockStateSerializationHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketBufferFieldHandlers {
    private static final Map<Class<?>, Pair<Reader, Writer>> packetBufferHandlers = new HashMap();
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T> void addIOHandler(Class<T> type, Reader<T> reader, Writer<T> writer) {
        packetBufferHandlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    public static boolean hasIOHandler(Class clz) {
        if (packetBufferHandlers.containsKey(clz)) {
            return true;
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!packetBufferHandlers.containsKey(iface)) continue;
            return true;
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return PacketBufferFieldHandlers.hasIOHandler(superClass);
    }

    public static Pair<Reader, Writer> getIOHandler(Class clz) {
        if (packetBufferHandlers.containsKey(clz)) {
            return packetBufferHandlers.get(clz);
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!packetBufferHandlers.containsKey(iface)) continue;
            return packetBufferHandlers.get(iface);
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return PacketBufferFieldHandlers.getIOHandler(superClass);
    }

    static {
        PacketBufferFieldHandlers.addIOHandler(boolean[].class, buf -> {
            int size = buf.readInt();
            boolean[] result = new boolean[size];
            for (int i = 0; i < size; ++i) {
                result[i] = buf.readBoolean();
            }
            return result;
        }, (booleans, buf) -> {
            buf.writeInt(((boolean[])booleans).length);
            for (boolean b : booleans) {
                buf.writeBoolean(b);
            }
        });
        PacketBufferFieldHandlers.addIOHandler(Boolean.TYPE, buf -> buf.readBoolean(), (b, buf) -> buf.writeBoolean(b.booleanValue()));
        PacketBufferFieldHandlers.addIOHandler(Boolean.class, buf -> buf.readBoolean(), (b, buf) -> buf.writeBoolean(b.booleanValue()));
        PacketBufferFieldHandlers.addIOHandler(Integer.TYPE, buf -> buf.readInt(), (i, buf) -> buf.writeInt(i.intValue()));
        PacketBufferFieldHandlers.addIOHandler(Integer.class, buf -> buf.readInt(), (i, buf) -> buf.writeInt(i.intValue()));
        PacketBufferFieldHandlers.addIOHandler(Float.TYPE, buf -> Float.valueOf(buf.readFloat()), (f, buf) -> buf.writeFloat(f.floatValue()));
        PacketBufferFieldHandlers.addIOHandler(Float.class, buf -> Float.valueOf(buf.readFloat()), (f, buf) -> buf.writeFloat(f.floatValue()));
        PacketBufferFieldHandlers.addIOHandler(Double.TYPE, buf -> buf.readDouble(), (d, buf) -> buf.writeDouble(d.doubleValue()));
        PacketBufferFieldHandlers.addIOHandler(Double.class, buf -> buf.readDouble(), (d, buf) -> buf.writeDouble(d.doubleValue()));
        PacketBufferFieldHandlers.addIOHandler(Long.TYPE, buf -> buf.readLong(), (l, buf) -> buf.writeLong(l.longValue()));
        PacketBufferFieldHandlers.addIOHandler(Long.class, buf -> buf.readLong(), (l, buf) -> buf.writeLong(l.longValue()));
        PacketBufferFieldHandlers.addIOHandler(String.class, buf -> buf.m_130277_(), (s, buf) -> buf.m_130070_(s));
        PacketBufferFieldHandlers.addIOHandler(ItemStack.class, buf -> buf.m_130267_(), (itemStack, buf) -> buf.m_130055_(itemStack));
        PacketBufferFieldHandlers.addIOHandler(ItemStackHandler.class, buf -> {
            ItemStackHandler result = new ItemStackHandler();
            result.deserializeNBT(buf.m_130260_());
            return result;
        }, (itemStackHandler, buf) -> buf.m_130079_(itemStackHandler.serializeNBT()));
        PacketBufferFieldHandlers.addIOHandler(Ingredient.class, buf -> Ingredient.m_43940_((FriendlyByteBuf)buf), (ingredient, buf) -> ingredient.m_43923_(buf));
        PacketBufferFieldHandlers.addIOHandler(Enum.class, buf -> {
            try {
                Class<?> clz = Class.forName(buf.m_130277_());
                return buf.m_130066_(clz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }, (anEnum, buf) -> {
            buf.m_130070_(anEnum.getClass().getName());
            buf.m_130068_(anEnum);
        });
        PacketBufferFieldHandlers.addIOHandler(Class.class, buf -> {
            try {
                return Class.forName(buf.m_130277_());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }, (aClass, buf) -> buf.m_130070_(aClass.getName()));
        PacketBufferFieldHandlers.addIOHandler(ResourceLocation.class, buf -> buf.m_130281_(), (resourceLocation, buf) -> buf.m_130085_(resourceLocation));
        PacketBufferFieldHandlers.addIOHandler(BlockPos.class, buf -> buf.m_130135_(), (pos, buf) -> buf.m_130064_(pos));
        PacketBufferFieldHandlers.addIOHandler(BlockState.class, buf -> BlockStateSerializationHelper.deserializeBlockState(buf), (blockState, buf) -> BlockStateSerializationHelper.serializeBlockState(buf, blockState));
        PacketBufferFieldHandlers.addIOHandler(UUID.class, buf -> buf.m_130259_(), (uuid, buf) -> buf.m_130077_(uuid));
        PacketBufferFieldHandlers.addIOHandler(INBTSerializable.class, buf -> {
            CompoundTag store = buf.m_130260_();
            Tag v = store.m_128423_("v");
            String className = store.m_128461_("c");
            try {
                Class<?> clz = Class.forName(className);
                INBTSerializable obj = (INBTSerializable)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                obj.deserializeNBT(v);
                return obj;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }, (inbtSerializable, buf) -> {
            CompoundTag store = new CompoundTag();
            store.m_128359_("c", inbtSerializable.getClass().getName());
            store.m_128365_("v", inbtSerializable.serializeNBT());
            buf.m_130079_(store);
        });
        PacketBufferFieldHandlers.addIOHandler(Map.class, buf -> {
            if (buf.readBoolean()) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap();
            try {
                Class<?> keyClass = Class.forName(buf.m_130277_());
                if (!PacketBufferFieldHandlers.hasIOHandler(keyClass)) {
                    LOGGER.warn("No PacketBuffer deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return Collections.emptyMap();
                }
                Class<?> valueClass = Class.forName(buf.m_130277_());
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    LOGGER.warn("No PacketBuffer deserialization methods for values in map (type='{}') exists.", valueClass);
                    return Collections.emptyMap();
                }
                int entryCount = buf.readInt();
                Reader keyReader = (Reader)PacketBufferFieldHandlers.getIOHandler(keyClass).getLeft();
                Reader valueReader = (Reader)PacketBufferFieldHandlers.getIOHandler(valueClass).getLeft();
                for (int entryNum = 0; entryNum < entryCount; ++entryNum) {
                    Object keyObject = keyReader.read(buf);
                    Object valueObject = valueReader.read(buf);
                    result.put(keyObject, valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (map, buf) -> {
            buf.writeBoolean(map.isEmpty());
            if (!map.isEmpty()) {
                Class<?> keyClass = map.keySet().toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(keyClass)) {
                    LOGGER.warn("No PacketBuffer deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return;
                }
                Class<?> valueClass = map.values().toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    LOGGER.warn("No PacketBuffer deserialization methods for values in map (type='{}') exists.", valueClass);
                    return;
                }
                buf.m_130070_(keyClass.getName());
                buf.m_130070_(valueClass.getName());
                buf.writeInt(map.entrySet().size());
                Writer keyWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(keyClass).getRight();
                Writer valueWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(valueClass).getRight();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e;
                    Map.Entry entry = e = iterator.next();
                    keyWriter.write(entry.getKey(), buf);
                    valueWriter.write(entry.getValue(), buf);
                }
            }
        });
        PacketBufferFieldHandlers.addIOHandler(List.class, buf -> {
            if (buf.readBoolean()) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            try {
                Class<?> valueClass = Class.forName(buf.m_130277_());
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    LOGGER.warn("No PacketBuffer deserialization methods for values in list (type='{}') exists.", valueClass);
                    return Collections.emptyList();
                }
                int entryCount = buf.readInt();
                Reader valueReader = (Reader)PacketBufferFieldHandlers.getIOHandler(valueClass).getLeft();
                for (int entryNum = 0; entryNum < entryCount; ++entryNum) {
                    Object valueObject = valueReader.read(buf);
                    result.add(valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (list, buf) -> {
            buf.writeBoolean(list.isEmpty());
            if (!list.isEmpty()) {
                Class<?> valueClass = list.toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    LOGGER.warn("No PacketBuffer serialization methods for values in list (type='{}') exists.", valueClass);
                    return;
                }
                buf.m_130070_(valueClass.getName());
                buf.writeInt(list.size());
                Writer valueWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(valueClass).getRight();
                for (Object e : list) {
                    valueWriter.write(e, buf);
                }
            }
        });
        PacketBufferFieldHandlers.addIOHandler(Queue.class, buf -> {
            if (buf.readBoolean()) {
                return new ArrayDeque();
            }
            ArrayDeque result = new ArrayDeque();
            try {
                Class<?> valueClass = Class.forName(buf.m_130277_());
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    LOGGER.warn("No PacketBuffer deserialization methods for values in list (type='{}') exists.", valueClass);
                    return new ArrayDeque();
                }
                int entryCount = buf.readInt();
                Reader valueReader = (Reader)PacketBufferFieldHandlers.getIOHandler(valueClass).getLeft();
                for (int entryNum = 0; entryNum < entryCount; ++entryNum) {
                    Object valueObject = valueReader.read(buf);
                    result.add(valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (queue, buf) -> {
            buf.writeBoolean(queue.isEmpty());
            if (!queue.isEmpty()) {
                Class<?> valueClass = queue.toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    LOGGER.warn("No PacketBuffer serialization methods for values in list (type='{}') exists.", valueClass);
                    return;
                }
                buf.m_130070_(valueClass.getName());
                buf.writeInt(queue.size());
                Writer valueWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(valueClass).getRight();
                for (Object e : queue) {
                    valueWriter.write(e, buf);
                }
            }
        });
        PacketBufferFieldHandlers.addIOHandler(Byte.TYPE, buf -> buf.readByte(), (b, buf) -> buf.writeByte((int)b.byteValue()));
    }

    public static interface Writer<T> {
        public void write(T var1, FriendlyByteBuf var2);
    }

    public static interface Reader<T> {
        public T read(FriendlyByteBuf var1);
    }
}

