/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad.blocks;

import com.robrit.snad.config.ConfigRegistry;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SnadBlock
extends FallingBlock {
    private final int dustColor;

    public SnadBlock(int dustColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.dustColor = dustColor;
    }

    @ParametersAreNonnullByDefault
    public int m_6248_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.dustColor;
    }

    @ParametersAreNonnullByDefault
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (plantable.getPlantType(world, pos) == PlantType.DESERT) {
            return true;
        }
        if (plantable.getPlantType(world, pos) == PlantType.BEACH) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                boolean isWater = world.m_6425_(pos.m_142300_(direction)).m_205070_(FluidTags.f_13131_);
                boolean isFrostedIce = world.m_8055_(pos.m_142300_(direction)).m_60713_(Blocks.f_50449_);
                if (!isWater && !isFrostedIce) continue;
                return true;
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_7455_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        this.m_7458_(blockState, serverLevel, blockPos, random);
    }

    @ParametersAreNonnullByDefault
    public void m_7458_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        Block blockAbove = serverLevel.m_8055_(blockPos.m_7494_()).m_60734_();
        if (blockAbove instanceof IPlantable) {
            boolean isSameBlockType = true;
            int height = 1;
            while (isSameBlockType) {
                if (blockPos.m_6630_(height).m_123342_() < serverLevel.m_151558_()) {
                    Block nextBlock = serverLevel.m_8055_(blockPos.m_6630_(height)).m_60734_();
                    if (nextBlock.getClass() == blockAbove.getClass()) {
                        for (int growthAttempts = 0; growthAttempts < (Integer)ConfigRegistry.GROWTH_SPEED.get(); ++growthAttempts) {
                            nextBlock.m_7455_(serverLevel.m_8055_(blockPos.m_6630_(height)), serverLevel, blockPos.m_6630_(height), random);
                        }
                        ++height;
                        continue;
                    }
                    isSameBlockType = false;
                    continue;
                }
                isSameBlockType = false;
            }
        }
    }
}

