/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.helper.category;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.util.NameUtil;
import com.blamejared.crafttweaker.impl.registry.CraftTweakerRegistry;
import com.blamejared.jeitweaker.helper.category.JeiCategoryCreator;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class JeiCategoryHelper {
    private static final Map<Class<?>, JeiCategoryCreator<?>> CREATORS = (Map)Util.m_137469_(new HashMap(), JeiCategoryHelper::lookup);

    public static void initialize() {
    }

    public static <T extends JeiCategory> T of(Class<T> typeToken, String id, Component name, JeiDrawable icon, RawJeiIngredient[] catalysts, Consumer<T> configurator) {
        ResourceLocation checkedId = NameUtil.fromFixedName((String)id, (fixed, mistakes) -> CraftTweakerAPI.LOGGER.warn("Invalid category ID '{}' specified due to the following mistakes:\n{}\nThe new rename will be '{}'", (Object)id, (Object)String.join((CharSequence)"\n", mistakes), fixed));
        return (T)((JeiCategory)Util.m_137469_(JeiCategoryHelper.of(typeToken).of(checkedId, name, icon, catalysts), configurator));
    }

    private static <T extends JeiCategory> JeiCategoryCreator<T> of(Class<T> type) {
        return Objects.requireNonNull(CREATORS.get(type), () -> "Invalid category type supplied: " + type.getName());
    }

    private static void lookup(Map<Class<?>, JeiCategoryCreator<?>> map) {
        CraftTweakerRegistry.get().getZenClassRegistry().getImplementationsOf(CraftTweakerAPI.getRegistry().findLoader("crafttweaker"), JeiCategory.class).stream().filter(type -> !Modifier.isAbstract(type.getModifiers())).forEach(type -> JeiCategoryCreator.of(type).ifPresent(creator -> map.put((Class<?>)type, (JeiCategoryCreator<?>)creator)));
    }
}

